/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentDescription {
    private static final Logger log = LoggerFactory.getLogger(DocumentDescription.class);
    private Schema metaSchema;
    private List<Schema> extensions;

    public DocumentDescription(ResourceType resourceType, JsonNode jsonNode) {
        if (!jsonNode.isObject()) {
            String errorMessage = String.format("The received resource document is not an object '%s'", jsonNode);
            throw new DocumentValidationException(errorMessage, Integer.valueOf(400), null);
        }
        this.extensions = new ArrayList<Schema>();
        ObjectNode resourceDocument = (ObjectNode)jsonNode;
        for (ResourceType.SchemaExtension schemaExtension : resourceType.getSchemaExtensions()) {
            this.addPresentOrRemoveNonePresentExtensions(resourceType, resourceDocument, schemaExtension);
        }
        ArrayNode schemasNode = new ArrayNode(JsonNodeFactory.instance);
        String mainSchemaUri = resourceType.getSchema();
        schemasNode.add(mainSchemaUri);
        this.extensions.stream().map(Schema::getNonNullId).forEach(arg_0 -> ((ArrayNode)schemasNode).add(arg_0));
        resourceDocument.set("schemas", (JsonNode)schemasNode);
        this.metaSchema = resourceType.getMainSchema();
        log.trace("Determined main schema as '{}'", (Object)this.metaSchema.getNonNullId());
        log.trace("Determined present extensions '{}'", this.extensions);
    }

    private void addPresentOrRemoveNonePresentExtensions(ResourceType resourceType, ObjectNode resourceDocument, ResourceType.SchemaExtension schemaExtension) {
        boolean isExtensionPresent;
        JsonNode extensionNode = resourceDocument.get(schemaExtension.getSchema());
        boolean bl = isExtensionPresent = extensionNode != null && !extensionNode.isNull() && !extensionNode.isEmpty();
        if (isExtensionPresent) {
            Schema extensionSchema = resourceType.getSchemaFactory().getResourceSchema(schemaExtension.getSchema());
            this.extensions.add(extensionSchema);
        } else {
            resourceDocument.remove(schemaExtension.getSchema());
        }
    }

    public Schema getMetaSchema() {
        return this.metaSchema;
    }

    public List<Schema> getExtensions() {
        return this.extensions;
    }
}

