/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsAzurePatchValueSubAttributeRebuilder
extends PatchWorkaround {
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchValueSubAttributeRebuilder.class);

    @Override
    public boolean shouldBeHandled(PatchConfig patchConfig, ResourceType resourceType, PatchRequestOperation operation) {
        return patchConfig.isMsAzureValueSubAttributeWorkaroundActive();
    }

    @Override
    public boolean executeOtherHandlers() {
        return true;
    }

    @Override
    public PatchRequestOperation fixPatchRequestOperaton(ResourceType resourceType, PatchRequestOperation operation) {
        PatchOp patchOp = operation.getOp();
        List patchValues = operation.getValues();
        if (PatchOp.REMOVE.equals((Object)patchOp)) {
            log.trace("[MS Azure value-subAttribute workaround] only handling 'REPLACE' and 'ADD' requests");
            return operation;
        }
        if (patchValues == null || patchValues.isEmpty()) {
            log.trace("[MS Azure value-subAttribute workaround] not executed for values-list is empty");
            return operation;
        }
        ArrayList<String> fixedValues = new ArrayList<String>();
        for (String patchValue : patchValues) {
            JsonNode innerObjectNode;
            JsonNode jsonNode;
            try {
                jsonNode = JsonHelper.readJsonDocument((String)patchValue);
            }
            catch (Exception ex) {
                log.trace("[MS Azure value-subAttribute workaround] ignored value-node because it is no valid JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            boolean isObjectNode = jsonNode instanceof ObjectNode;
            if (!isObjectNode) {
                log.trace("[MS Azure value-subAttribute workaround] ignored value because it is no JSON-ObjectNode");
                fixedValues.add(patchValue);
                continue;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.size() != 1) {
                log.trace("[MS Azure value-subAttribute workaround] ignored JSON-ObjectNode because it has less or more than 1 sub-nodes");
                fixedValues.add(patchValue);
                continue;
            }
            JsonNode innerValueNode = objectNode.get("value");
            if (innerValueNode == null) {
                log.trace("[MS Azure value-subAttribute workaround] ignored JSON-ObjectNode because it has no value-node");
                fixedValues.add(patchValue);
                continue;
            }
            try {
                innerObjectNode = JsonHelper.readJsonDocument((String)innerValueNode.textValue());
            }
            catch (Exception ex) {
                log.trace("[MS Azure value-subAttribute workaround] ignored inner value-node because it is no valid JSON-node");
                fixedValues.add(patchValue);
                continue;
            }
            isObjectNode = innerObjectNode instanceof ObjectNode;
            if (!isObjectNode) {
                log.trace("[MS Azure value-subAttribute workaround] ignored inner value-node because it is no not a JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            fixedValues.add(innerObjectNode.toString());
        }
        return PatchRequestOperation.builder().op(patchOp).path((String)operation.getPath().orElse(null)).values(fixedValues).build();
    }
}

