/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.AttributeExpressionLeaf;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.util.List;
import java.util.Optional;

public class MsAzurePatchFilterWorkaround
extends PatchWorkaround {
    @Override
    public boolean shouldBeHandled(PatchConfig patchConfig, ResourceType resourceType, PatchRequestOperation operation) {
        Optional path = operation.getPath();
        return patchConfig.isMsAzureFilterWorkaroundActive() && !PatchOp.REMOVE.equals((Object)operation.getOp()) && path.isPresent() && operation.getValues().size() == 1 && ((String)path.get()).matches(".*?\\[.*?]\\..*");
    }

    @Override
    public boolean executeOtherHandlers() {
        return false;
    }

    @Override
    public PatchRequestOperation fixPatchRequestOperaton(ResourceType resourceType, PatchRequestOperation operation) {
        PatchOp patchOp = operation.getOp();
        Optional path = operation.getPath();
        List values = operation.getValues();
        if (resourceType.getAllSchemaExtensions().stream().anyMatch(schema -> schema.getNonNullId().equals(path.get()))) {
            return operation;
        }
        AttributePathRoot attributePathRoot = RequestUtils.parsePatchPath(resourceType, (String)path.get());
        SchemaAttribute schemaAttribute = attributePathRoot.getSchemaAttribute();
        FilterNode childNode = attributePathRoot.getChild();
        if (!(childNode instanceof AttributeExpressionLeaf)) {
            return operation;
        }
        ScimObjectNode value = new ScimObjectNode();
        value.set(attributePathRoot.getSubAttributeName(), (JsonNode)new ScimTextNode(null, (String)values.get(0)));
        AttributeExpressionLeaf attributeExpressionLeaf = (AttributeExpressionLeaf)childNode;
        value.set(attributeExpressionLeaf.getSchemaAttribute().getName(), (JsonNode)new ScimTextNode(null, attributeExpressionLeaf.getValue()));
        return PatchRequestOperation.builder().op(patchOp).path(schemaAttribute.getFullResourceName()).valueNode((JsonNode)value).build();
    }
}

