/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsAzurePatchComplexValueRebuilder
extends PatchWorkaround {
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchComplexValueRebuilder.class);
    private SchemaAttribute schemaAttribute;

    @Override
    public boolean shouldBeHandled(PatchConfig patchConfig, ResourceType resourceType, PatchRequestOperation operation) {
        boolean isWorkaroundActive = patchConfig.isMsAzureComplexSimpleValueWorkaroundActive();
        if (!isWorkaroundActive) {
            return false;
        }
        String attributeName = operation.getPath().orElse(null);
        if (attributeName == null) {
            return false;
        }
        try {
            this.schemaAttribute = RequestUtils.getSchemaAttributeByAttributeName(resourceType, attributeName);
        }
        catch (Exception ex) {
            return false;
        }
        boolean isComplexDefinition = Type.COMPLEX.equals((Object)this.schemaAttribute.getType());
        if (!isComplexDefinition) {
            log.trace("[MS Azure complex-patch-path-value workaround] ignoring non-complex attribute {}", (Object)this.schemaAttribute.getScimNodeName());
            return false;
        }
        ArrayNode arrayNode = operation.getValueNode().orElse(null);
        if (arrayNode == null) {
            return false;
        }
        for (JsonNode jsonNode : arrayNode) {
            if (jsonNode.isObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean executeOtherHandlers() {
        return true;
    }

    @Override
    public PatchRequestOperation fixPatchRequestOperaton(ResourceType resourceType, PatchRequestOperation operation) {
        List patchValues = operation.getValues();
        ArrayList<String> fixedValues = new ArrayList<String>();
        for (int i = 0; i < patchValues.size(); ++i) {
            JsonNode jsonNode;
            String patchValue = (String)patchValues.get(i);
            try {
                jsonNode = JsonHelper.readJsonDocument((String)patchValue);
            }
            catch (Exception ex) {
                log.trace("[MS Azure complex-patch-path-value workaround] ignored value-node because it is no valid JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            if (jsonNode.isObject() || jsonNode.isArray()) {
                log.trace("[MS Azure complex-patch-path-value workaround] ignoring non-simple-value for attribute {}", (Object)this.schemaAttribute.getScimNodeName());
                fixedValues.add(patchValue);
                continue;
            }
            log.trace("[MS Azure complex-patch-path-value workaround] replacing simple-value with objectNode on attribute {}", (Object)this.schemaAttribute.getScimNodeName());
            ScimObjectNode complexObjectNode = new ScimObjectNode(this.schemaAttribute);
            complexObjectNode.set("value", (JsonNode)new TextNode(patchValue));
            fixedValues.add(complexObjectNode.toString());
        }
        operation.setValues(fixedValues);
        return operation;
    }
}

