/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.operations;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.utils.ScimAttributeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class PatchOperation<T extends JsonNode>
implements ScimAttributeHelper {
    protected final Schema schema;
    protected final SchemaAttribute schemaAttribute;
    protected final PatchOp patchOp;
    protected final T valuesNode;
    protected final List<String> valueStringList;

    public PatchOperation(SchemaAttribute schemaAttribute, PatchOp patchOp, JsonNode valuesNode) {
        this.schema = schemaAttribute.getSchema();
        this.schemaAttribute = schemaAttribute;
        this.patchOp = patchOp;
        this.valuesNode = this.parseJsonNode(valuesNode);
        this.valueStringList = new ArrayList<String>();
    }

    public PatchOperation(Schema schema, SchemaAttribute schemaAttribute, PatchOp patchOp, JsonNode valuesNode) {
        this.schema = schema;
        this.schemaAttribute = schemaAttribute;
        this.patchOp = patchOp;
        this.valuesNode = this.parseJsonNode(valuesNode);
        this.valueStringList = new ArrayList<String>();
    }

    public abstract T parseJsonNode(JsonNode var1);

    public abstract AttributePathRoot getAttributePath();

    public SchemaAttribute getDirectlyReferencedAttribute() {
        return this.getAttributePath().getDirectlyReferencedAttribute();
    }

    public FilterNode getFilter() {
        return this.getAttributePath().getChild();
    }

    public boolean isWithFilter() {
        return this.getAttributePath().getChild() != null;
    }

    public boolean isReferencingSubAttribute() {
        return this.schemaAttribute.getParent() != null || Optional.ofNullable(this.getAttributePath()).map(attributePathRoot -> attributePathRoot.getDirectlyReferencedAttribute().getParent() != null).orElse(false) != false;
    }

    public boolean isRemoveOp() {
        return PatchOp.REMOVE.equals((Object)this.patchOp);
    }

    public boolean isReplaceOp() {
        return PatchOp.REPLACE.equals((Object)this.patchOp);
    }

    public boolean isAddOp() {
        return PatchOp.ADD.equals((Object)this.patchOp);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SchemaAttribute getSchemaAttribute() {
        return this.schemaAttribute;
    }

    public PatchOp getPatchOp() {
        return this.patchOp;
    }

    public T getValuesNode() {
        return this.valuesNode;
    }

    public List<String> getValueStringList() {
        return this.valueStringList;
    }
}

