/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;

public abstract class AbstractPatch {
    protected final ResourceType resourceType;

    public AbstractPatch(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    protected SchemaAttribute getSchemaAttribute(String key) {
        try {
            return RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, key);
        }
        catch (ScimException ex) {
            ex.setScimType("invalidPath");
            ex.setStatus(400);
            throw ex;
        }
    }

    protected JsonNode getAttributeFromObject(JsonNode parentNode, String attributeName) {
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(attributeName);
        JsonNode child = parentNode.get(schemaAttribute.getName());
        if (child == null && schemaAttribute.isMultiValued()) {
            child = this.createNewMultiValuedNode(parentNode, schemaAttribute);
        }
        return child;
    }

    private JsonNode createNewMultiValuedNode(JsonNode parentNode, SchemaAttribute schemaAttribute) {
        ScimArrayNode scimArrayNode = new ScimArrayNode(schemaAttribute);
        if (parentNode.isArray()) {
            ((ArrayNode)parentNode).add((JsonNode)scimArrayNode);
        } else {
            ((ObjectNode)parentNode).set(schemaAttribute.getName(), (JsonNode)scimArrayNode);
        }
        return scimArrayNode;
    }
}

