/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter.antlr;

import de.captaingoldfish.scim.sdk.common.exceptions.InvalidDateTimeRepresentationException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidFilterException;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareValue {
    private static final Logger log = LoggerFactory.getLogger(CompareValue.class);
    private ScimFilterParser.CompareValueContext context;
    private String value;

    public CompareValue(ScimFilterParser.CompareValueContext compareValueContext, SchemaAttribute schemaAttribute) {
        this.context = compareValueContext;
        this.value = compareValueContext.isNull != null ? null : compareValueContext.getText().replaceFirst("^\"", "").replaceFirst("\"$", "");
        this.validateCompareValue(schemaAttribute);
    }

    private void validateCompareValue(SchemaAttribute schemaAttribute) {
        switch (schemaAttribute.getType()) {
            case DATE_TIME: {
                this.validateAttributeType(schemaAttribute, () -> this.isDateTime() || this.isString() || this.isNull());
                break;
            }
            case BOOLEAN: {
                this.validateAttributeType(schemaAttribute, () -> this.isFalse() || this.isTrue() || this.isNull());
                break;
            }
            case INTEGER: 
            case DECIMAL: {
                this.validateAttributeType(schemaAttribute, () -> this.isNumber() || this.isNull());
                break;
            }
            case REFERENCE: 
            case STRING: {
                this.validateAttributeType(schemaAttribute, () -> this.isString() || this.isNull());
                break;
            }
        }
    }

    private void validateAttributeType(SchemaAttribute schemaAttribute, Supplier<Boolean> isOfType) {
        if (!isOfType.get().booleanValue()) {
            throw new InvalidFilterException("attribute '" + schemaAttribute.getFullResourceName() + "' is of type '" + schemaAttribute.getType() + "' but the given value '" + this.value + "' does not apply to this type", null);
        }
    }

    private boolean isTrue() {
        return this.context.isTrue != null;
    }

    private boolean isFalse() {
        return this.context.isFalse != null;
    }

    public boolean isNull() {
        return this.context.isNull != null;
    }

    public boolean isNumber() {
        return this.context.number != null;
    }

    public boolean isString() {
        return this.context.string != null;
    }

    public boolean isDateTime() {
        return this.getDateTime().isPresent();
    }

    public boolean isBoolean() {
        return this.isTrue() || this.isFalse();
    }

    public Optional<Boolean> getBooleanValue() {
        boolean isBoolean = this.isBoolean();
        if (isBoolean) {
            return Optional.of(this.isTrue());
        }
        return Optional.empty();
    }

    public Optional<BigDecimal> getNumberValue() {
        if (this.isNumber()) {
            try {
                return Optional.of(new BigDecimal(this.context.number.getText()));
            }
            catch (NumberFormatException ex) {
                log.trace(ex.getMessage(), (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public Optional<String> getStringValue() {
        if (this.isString()) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    public Optional<Instant> getDateTime() {
        if (!this.isString()) {
            return Optional.empty();
        }
        try {
            return Optional.of(TimeUtils.parseDateTime((String)this.value));
        }
        catch (InvalidDateTimeRepresentationException e) {
            log.trace(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public String toString() {
        if (this.isString()) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompareValue)) {
            return false;
        }
        CompareValue other = (CompareValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompareValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String getValue() {
        return this.value;
    }
}

