/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceUriWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceWrapper;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class BulkIdResolverAbstract<T extends JsonNode> {
    protected final String operationBulkId;
    protected final UriInfos uriInfos;
    protected final T resource;
    protected final Set<String> referencedBulkIds = new HashSet<String>();
    protected final Map<String, List<BulkIdReferenceWrapper>> bulkIdReferences;
    private boolean hadSuccessInLastRun;

    public BulkIdResolverAbstract(String operationBulkId, UriInfos uriInfos, T resource) {
        this.operationBulkId = operationBulkId;
        this.uriInfos = uriInfos;
        this.resource = resource;
        this.bulkIdReferences = new HashMap<String, List<BulkIdReferenceWrapper>>();
        this.resolveBulkIdInUri();
    }

    protected void findAllBulkIdReferences() {
        List bulkIdReferenceSet;
        boolean containsBulkIdReference = this.containsBulkIdReference((JsonNode)this.resource);
        if (!containsBulkIdReference) {
            return;
        }
        List<BulkIdReferenceWrapper> complexBulkIdReferences = this.getComplexBulkIdNodes();
        List<BulkIdReferenceWrapper> directBulkIdReferences = this.getDirectBulkIdNodes();
        for (BulkIdReferenceWrapper complexBulkIdReference : complexBulkIdReferences) {
            this.referencedBulkIds.add(complexBulkIdReference.getBulkId());
            bulkIdReferenceSet = this.bulkIdReferences.computeIfAbsent(complexBulkIdReference.getBulkId(), k -> new ArrayList());
            bulkIdReferenceSet.add(complexBulkIdReference);
        }
        for (BulkIdReferenceWrapper directBulkIdReference : directBulkIdReferences) {
            this.referencedBulkIds.add(directBulkIdReference.getBulkId());
            bulkIdReferenceSet = this.bulkIdReferences.computeIfAbsent(directBulkIdReference.getBulkId(), k -> new ArrayList());
            bulkIdReferenceSet.add(directBulkIdReference);
        }
    }

    private void resolveBulkIdInUri() {
        String possibleBulkIdReference = this.uriInfos.getResourceId();
        if (possibleBulkIdReference != null && possibleBulkIdReference.matches(String.format("%s:[\\w\\d[^/]]*$", "bulkId"))) {
            this.checkForBulkIdReferenceValidity(possibleBulkIdReference);
            String bulkId = possibleBulkIdReference.split(":")[1];
            this.referencedBulkIds.add(bulkId);
            List bulkIdReferenceSet = this.bulkIdReferences.computeIfAbsent(bulkId, k -> new ArrayList());
            bulkIdReferenceSet.add(new BulkIdReferenceUriWrapper(this.uriInfos, bulkId));
        }
    }

    protected abstract List<BulkIdReferenceWrapper> getComplexBulkIdNodes();

    protected abstract List<BulkIdReferenceWrapper> getDirectBulkIdNodes();

    public final void replaceBulkIdNode(String bulkId, String value) {
        List<BulkIdReferenceWrapper> bulkIdResourceReferenceWrappers = this.bulkIdReferences.get(bulkId);
        if (bulkIdResourceReferenceWrappers == null) {
            this.hadSuccessInLastRun = false;
            return;
        }
        this.hadSuccessInLastRun = bulkIdResourceReferenceWrappers.size() > 0;
        bulkIdResourceReferenceWrappers.forEach(reference -> reference.replaceValueNode(value));
        this.bulkIdReferences.remove(bulkId);
        this.referencedBulkIds.remove(bulkId);
    }

    public final boolean hasAnyBulkIdReferences() {
        return !this.bulkIdReferences.isEmpty();
    }

    public final Set<String> getUnresolvedBulkIds() {
        return this.bulkIdReferences.keySet();
    }

    public final boolean hasSelfReference() {
        return this.bulkIdReferences.containsKey(this.operationBulkId);
    }

    protected final boolean containsBulkIdReference(JsonNode jsonNode) {
        return StringUtils.contains((CharSequence)jsonNode.toString(), (CharSequence)String.format("\"%s:", "bulkId"));
    }

    protected void checkForBulkIdReferenceValidity(String bulkIdReferenceValue) {
        int bulkIdReferencePartsSize = bulkIdReferenceValue.split(":").length;
        if (bulkIdReferencePartsSize != 2) {
            throw new BadRequestException(String.format("the value '%s' is not a valid bulkId reference", bulkIdReferenceValue), null, "invalidValue");
        }
    }

    public <R extends ScimObjectNode> R getResource(Class<R> type) {
        return (R)((ScimObjectNode)JsonHelper.copyResourceToObject(this.resource, type));
    }

    public String getOperationBulkId() {
        return this.operationBulkId;
    }

    public UriInfos getUriInfos() {
        return this.uriInfos;
    }

    public T getResource() {
        return this.resource;
    }

    public Set<String> getReferencedBulkIds() {
        return this.referencedBulkIds;
    }

    public boolean isHadSuccessInLastRun() {
        return this.hadSuccessInLastRun;
    }
}

