/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceWrapper;

class BulkIdReferenceResourceWrapper
implements BulkIdReferenceWrapper {
    private final JsonNode parentNode;
    private final SchemaAttribute schemaAttribute;
    private final String bulkId;

    public BulkIdReferenceResourceWrapper(JsonNode parentNode, JsonNode valueNode, SchemaAttribute schemaAttribute) {
        this.parentNode = parentNode;
        this.schemaAttribute = schemaAttribute;
        String bulkIdReference = valueNode.textValue();
        this.bulkId = bulkIdReference.replaceFirst(String.format("^%s:", "bulkId"), "");
    }

    @Override
    public void replaceValueNode(String newValue) {
        JsonHelper.replaceNode((JsonNode)this.parentNode, (String)this.schemaAttribute.getName(), (JsonNode)new TextNode(newValue));
    }

    @Override
    public String getBulkId() {
        return this.bulkId;
    }
}

