/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceWrapper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BulkIdReferencePatchNodeWrapper
implements BulkIdReferenceWrapper {
    private static final Pattern GET_BULK_ID_PATTERN = Pattern.compile("^bulkId:(.*)|\"bulkId:(.*?)\"");
    private final PatchRequestOperation patchRequestOperation;
    private final String operationValue;
    private final int valueIndex;
    private final String bulkId;

    public BulkIdReferencePatchNodeWrapper(PatchRequestOperation patchRequestOperation, String operationValue, int valueIndex) {
        this.patchRequestOperation = patchRequestOperation;
        this.operationValue = operationValue;
        this.valueIndex = valueIndex;
        Matcher matcher = GET_BULK_ID_PATTERN.matcher(operationValue);
        matcher.find();
        this.bulkId = matcher.group(1) == null ? matcher.group(2) : matcher.group(1);
    }

    @Override
    public void replaceValueNode(String newValue) {
        List operations = this.patchRequestOperation.getValues();
        operations.remove(this.valueIndex);
        String newOperationValue = this.operationValue.replaceAll(String.format("%s:%s", "bulkId", this.bulkId), newValue);
        operations.add(this.valueIndex, newOperationValue);
        this.patchRequestOperation.setValues(operations);
    }

    @Override
    public String getBulkId() {
        return this.bulkId;
    }
}

