/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkget;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseGetOperation;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.ResourceReference;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.ResourceReferenceExtractor;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class BulkGetResolver {
    private final int maxResourceLevel;
    private final ScimResponse parentResourceResponse;
    private final ResourceType resourceType;
    private final ResourceTypeFactory resourceTypeFactory;
    private final BiFunction<String, ResourceType, ScimResponse> callResourceEndpoint;

    public BulkGetResolver(int maxResourceLevel, ScimResponse parentResourceResponse, ResourceType resourceType, ResourceTypeFactory resourceTypeFactory, BiFunction<String, ResourceType, ScimResponse> callResourceEndpoint) {
        this.maxResourceLevel = Math.max(1, maxResourceLevel);
        this.parentResourceResponse = parentResourceResponse;
        this.resourceType = resourceType;
        this.resourceTypeFactory = resourceTypeFactory;
        this.callResourceEndpoint = callResourceEndpoint;
    }

    public List<BulkResponseGetOperation> getTransitiveResources() {
        return this.getChildrenOfResource(this.parentResourceResponse, this.resourceType, 0);
    }

    private List<BulkResponseGetOperation> getChildrenOfResource(ScimResponse scimResponse, ResourceType resourceType, int currentDepth) {
        if (currentDepth == this.maxResourceLevel) {
            return Collections.emptyList();
        }
        ResourceReferenceExtractor resourceReferenceExtractor = new ResourceReferenceExtractor((ObjectNode)scimResponse, resourceType, this.resourceTypeFactory);
        List<ResourceReference> resourceReferences = resourceReferenceExtractor.getResourceReferences();
        return resourceReferences.stream().map(resourceReference -> this.getChildResource((ResourceReference)resourceReference, currentDepth)).collect(Collectors.toList());
    }

    private BulkResponseGetOperation getChildResource(ResourceReference resourceReference, int currentDepth) {
        String resourceId = resourceReference.getResourceId();
        ResourceType childResourceType = resourceReference.getResourceType();
        String nodePath = resourceReference.getNodePath();
        ScimResponse scimResponse = this.callResourceEndpoint.apply(resourceId, childResourceType);
        List<Object> children = new ArrayList();
        if (currentDepth < this.maxResourceLevel) {
            children = this.getChildrenOfResource(scimResponse, childResourceType, currentDepth + 1);
        }
        return BulkResponseGetOperation.builder().resource(scimResponse).resourceId(resourceId).status(Integer.valueOf(scimResponse.getHttpStatus())).resourceType(childResourceType.getName()).nodePath(nodePath).children(children).build();
    }

    public static BulkGetResolverBuilder builder() {
        return new BulkGetResolverBuilder();
    }

    public static class BulkGetResolverBuilder {
        private int maxResourceLevel;
        private ScimResponse parentResourceResponse;
        private ResourceType resourceType;
        private ResourceTypeFactory resourceTypeFactory;
        private BiFunction<String, ResourceType, ScimResponse> callResourceEndpoint;

        BulkGetResolverBuilder() {
        }

        public BulkGetResolverBuilder maxResourceLevel(int maxResourceLevel) {
            this.maxResourceLevel = maxResourceLevel;
            return this;
        }

        public BulkGetResolverBuilder parentResourceResponse(ScimResponse parentResourceResponse) {
            this.parentResourceResponse = parentResourceResponse;
            return this;
        }

        public BulkGetResolverBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public BulkGetResolverBuilder resourceTypeFactory(ResourceTypeFactory resourceTypeFactory) {
            this.resourceTypeFactory = resourceTypeFactory;
            return this;
        }

        public BulkGetResolverBuilder callResourceEndpoint(BiFunction<String, ResourceType, ScimResponse> callResourceEndpoint) {
            this.callResourceEndpoint = callResourceEndpoint;
            return this;
        }

        public BulkGetResolver build() {
            return new BulkGetResolver(this.maxResourceLevel, this.parentResourceResponse, this.resourceType, this.resourceTypeFactory, this.callResourceEndpoint);
        }

        public String toString() {
            return "BulkGetResolver.BulkGetResolverBuilder(maxResourceLevel=" + this.maxResourceLevel + ", parentResourceResponse=" + this.parentResourceResponse + ", resourceType=" + (Object)((Object)this.resourceType) + ", resourceTypeFactory=" + this.resourceTypeFactory + ", callResourceEndpoint=" + this.callResourceEndpoint + ")";
        }
    }
}

