/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.DefaultAuthorization;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Context {
    private Authorization authorization;
    private UriInfos uriInfos;
    private Function<String, String> resourceReferenceUrl;
    private BiFunction<String, String, String> crossResourceReferenceUrl;
    private Supplier<String> requestBodySupplier;

    public Context(Authorization authorization) {
        this.authorization = Optional.ofNullable(authorization).orElse(new DefaultAuthorization());
    }

    public String getResourceReferenceUrl(String id) {
        return this.resourceReferenceUrl.apply(id);
    }

    public Optional<String> getCrossResourceReferenceUrl(String id, String resourceName) {
        return Optional.ofNullable(this.crossResourceReferenceUrl.apply(id, resourceName));
    }

    public String getRequestBody() {
        return this.requestBodySupplier.get();
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public UriInfos getUriInfos() {
        return this.uriInfos;
    }

    protected void setUriInfos(UriInfos uriInfos) {
        this.uriInfos = uriInfos;
    }

    protected void setResourceReferenceUrl(Function<String, String> resourceReferenceUrl) {
        this.resourceReferenceUrl = resourceReferenceUrl;
    }

    protected void setCrossResourceReferenceUrl(BiFunction<String, String, String> crossResourceReferenceUrl) {
        this.crossResourceReferenceUrl = crossResourceReferenceUrl;
    }

    protected void setRequestBodySupplier(Supplier<String> requestBodySupplier) {
        this.requestBodySupplier = requestBodySupplier;
    }
}

