/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractResourceValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ResponseSchemaValidator;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResourceValidator
extends AbstractResourceValidator {
    private static final Logger log = LoggerFactory.getLogger(ResponseResourceValidator.class);

    public ResponseResourceValidator(ServiceProvider serviceProvider, ResourceType resourceType, List<SchemaAttribute> attributesList, List<SchemaAttribute> excludedAttributesList, JsonNode requestDocument, BiFunction<String, String, String> referenceUrlSupplier) {
        super(resourceType, new ResponseSchemaValidator(serviceProvider, resourceType.getResourceHandlerImpl().getType(), attributesList, excludedAttributesList, requestDocument, referenceUrlSupplier));
    }

    @Override
    public ScimObjectNode validateDocument(JsonNode resource) {
        boolean isEmpty;
        log.trace("Start validating response resource");
        ScimObjectNode validatedResource = super.validateDocument(resource);
        ScimObjectNode metaAttributeWrapper = this.getSchemaValidator().validateDocument(new ScimObjectNode(null), this.getResourceType().getMetaSchema(), resource);
        if (!metaAttributeWrapper.isEmpty()) {
            JsonNode metaNode = metaAttributeWrapper.get("meta");
            validatedResource.set("meta", metaNode);
        }
        boolean containsOnlyAttributesSchemasAndMeta = validatedResource.size() == 2 && validatedResource.has("schemas") && validatedResource.has("meta");
        boolean bl = isEmpty = validatedResource.isEmpty() || containsOnlyAttributesSchemasAndMeta;
        if (isEmpty) {
            log.debug("Validated response resource is empty");
            return null;
        }
        return validatedResource;
    }

    @Override
    protected void checkForMissingRequiredExtensions(List<Schema> requiredExtensionList, List<Schema> inResourcePresentExtensions) {
        if (!this.getSchemaValidator().getServiceProvider().isIgnoreRequiredExtensionsOnResponse()) {
            super.checkForMissingRequiredExtensions(requiredExtensionList, inResourcePresentExtensions);
        }
    }

    @Override
    protected int getHttpStatusCode() {
        return 500;
    }
}

