/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Returned;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(ResponseAttributeValidator.class);

    ResponseAttributeValidator() {
    }

    public static Optional<JsonNode> validateAttribute(ServiceProvider serviceProvider, SchemaAttribute schemaAttribute, JsonNode attribute, JsonNode requestDocument, List<SchemaAttribute> attributesList, List<SchemaAttribute> excludedAttributesList, BiFunction<String, String, String> referenceUrlSupplier) {
        ContextValidator requestContextValidator = ResponseAttributeValidator.getContextValidator(serviceProvider, attributesList, requestDocument, excludedAttributesList, referenceUrlSupplier);
        Optional<JsonNode> validatedNode = ValidationSelector.validateNode(schemaAttribute, attribute, requestContextValidator);
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            try {
                ResponseAttributeValidator.validateRequiredAttribute(serviceProvider, schemaAttribute, !validatedNode.isPresent(), attributesList, excludedAttributesList);
            }
            catch (AttributeValidationException ex) {
                String errorMessage = String.format("The required attribute '%s' was evaluated to an empty during schema validation but the attribute is required '%s'", schemaAttribute.getFullResourceName(), attribute);
                throw new AttributeValidationException(schemaAttribute, errorMessage, ex);
            }
        }
        return validatedNode;
    }

    private static ContextValidator getContextValidator(final ServiceProvider serviceProvider, final List<SchemaAttribute> attributesList, final JsonNode requestDocument, final List<SchemaAttribute> excludedAttributesList, final BiFunction<String, String, String> referenceUrlSupplier) {
        return new ContextValidator(serviceProvider, ContextValidator.ValidationContextType.RESPONSE){

            @Override
            public boolean validateContext(SchemaAttribute schemaAttribute, JsonNode attribute) throws AttributeValidationException {
                boolean validateNode = ResponseAttributeValidator.validateNode(serviceProvider, schemaAttribute, attribute, requestDocument, attributesList, excludedAttributesList);
                if (validateNode && Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
                    ResponseAttributeValidator.overrideEmptyReferenceNode(schemaAttribute, attribute, referenceUrlSupplier);
                }
                return validateNode;
            }
        };
    }

    private static boolean validateNode(ServiceProvider serviceProvider, SchemaAttribute schemaAttribute, JsonNode attribute, JsonNode requestDocument, List<SchemaAttribute> attributesList, List<SchemaAttribute> excludedAttributesList) {
        boolean isExcludedAttribute;
        boolean isRequestedAttribute;
        if (Mutability.WRITE_ONLY.equals((Object)schemaAttribute.getMutability()) || Returned.NEVER.equals((Object)schemaAttribute.getReturned())) {
            if (attribute != null && !attribute.isNull()) {
                log.debug("Removing attribute '{}' from document due to its definition of mutability '{}' and returned '{}'", new Object[]{schemaAttribute.getFullResourceName(), schemaAttribute.getMutability(), schemaAttribute.getReturned()});
            }
            return false;
        }
        boolean isNodeNull = attribute == null || attribute.isNull();
        ResponseAttributeValidator.validateRequiredAttribute(serviceProvider, schemaAttribute, isNodeNull, attributesList, excludedAttributesList);
        if (isNodeNull) {
            return false;
        }
        if (Returned.ALWAYS.equals((Object)schemaAttribute.getReturned())) {
            return true;
        }
        boolean isAttributesParamUsed = attributesList != null && !attributesList.isEmpty();
        boolean bl = isRequestedAttribute = isAttributesParamUsed && ResponseAttributeValidator.isAttributePresentInList(schemaAttribute, attributesList) || ResponseAttributeValidator.isAttributePresentInRequest(schemaAttribute, requestDocument);
        if (Returned.REQUEST.equals((Object)schemaAttribute.getReturned()) && !isRequestedAttribute) {
            log.debug("Removing attribute '{}' from response. Returned value is '{}' and it was not present in the clients request", (Object)schemaAttribute.getFullResourceName(), (Object)Returned.REQUEST);
            return false;
        }
        boolean isExcludedAttributesParamUsed = excludedAttributesList != null && !excludedAttributesList.isEmpty();
        boolean bl2 = isExcludedAttribute = isExcludedAttributesParamUsed && ResponseAttributeValidator.isExcludedAttributePresentInList(schemaAttribute, excludedAttributesList);
        if (isAttributesParamUsed && !isRequestedAttribute && Returned.DEFAULT.equals((Object)schemaAttribute.getReturned())) {
            if (schemaAttribute.isRequired() && !isExcludedAttribute) {
                return true;
            }
            log.debug("Removing attribute '{}' from response. Param 'attributes' was used the returned value is '{}' and the attribute is not directly requested", (Object)schemaAttribute.getFullResourceName(), (Object)schemaAttribute.getReturned());
            return false;
        }
        if (isExcludedAttribute) {
            log.debug("Removing attribute '{}' from response. Attribute is present in the list of 'excludedAttributes'", (Object)schemaAttribute.getFullResourceName());
            return false;
        }
        return true;
    }

    private static boolean isAttributePresentInRequest(SchemaAttribute schemaAttribute, JsonNode requestDocument) {
        if (requestDocument == null) {
            return false;
        }
        JsonNode extensionNode = Optional.ofNullable(schemaAttribute.getResourceUri()).map(arg_0 -> ((JsonNode)requestDocument).get(arg_0)).orElse(null);
        boolean isExtensionNode = extensionNode != null;
        JsonNode document = isExtensionNode ? extensionNode : requestDocument;
        return ResponseAttributeValidator.isAttributePresentInDocument(schemaAttribute, document);
    }

    private static boolean isAttributePresentInDocument(SchemaAttribute schemaAttribute, JsonNode document) {
        boolean isPresent;
        String[] nameParts = schemaAttribute.getScimNodeName().split("\\.");
        JsonNode currentNode = document.get(nameParts[0]);
        boolean bl = isPresent = currentNode != null;
        if (nameParts.length == 1 || !isPresent) {
            return isPresent;
        }
        if (currentNode instanceof ArrayNode) {
            JsonNode jsonNode;
            ArrayNode currentArrayNode = (ArrayNode)currentNode;
            Iterator iterator = currentArrayNode.iterator();
            while (iterator.hasNext() && !(isPresent = (jsonNode = (JsonNode)iterator.next()).get(nameParts[1]) != null)) {
            }
        } else {
            boolean bl2 = isPresent = currentNode.get(nameParts[1]) != null;
            if (!isPresent) {
                return false;
            }
        }
        return isPresent;
    }

    private static void validateRequiredAttribute(ServiceProvider serviceProvider, SchemaAttribute schemaAttribute, boolean isNodeNull, List<SchemaAttribute> attributesList, List<SchemaAttribute> excludedAttributesList) {
        if (!schemaAttribute.isRequired() || serviceProvider.isIgnoreRequiredAttributesOnResponse()) {
            return;
        }
        boolean isWriteOnly = Mutability.WRITE_ONLY.equals((Object)schemaAttribute.getMutability());
        boolean isReturnedNever = Returned.NEVER.equals((Object)schemaAttribute.getReturned());
        if (isNodeNull && !isWriteOnly && !isReturnedNever) {
            boolean isExcludedByClient;
            boolean wereAttributesExcluded;
            boolean isDirectlyRequested;
            boolean wereAttributesRequested;
            boolean isReturnedAlways = Returned.ALWAYS.equals((Object)schemaAttribute.getReturned());
            boolean bl = wereAttributesRequested = attributesList != null && attributesList.size() > 0;
            if (!isReturnedAlways && wereAttributesRequested && !(isDirectlyRequested = attributesList.contains(schemaAttribute))) {
                return;
            }
            boolean bl2 = wereAttributesExcluded = excludedAttributesList != null && excludedAttributesList.size() > 0;
            if (wereAttributesExcluded && (isExcludedByClient = excludedAttributesList.contains(schemaAttribute))) {
                return;
            }
            String errorMessage = String.format("Required '%s' attribute '%s' is missing", schemaAttribute.getMutability(), schemaAttribute.getFullResourceName());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static boolean isAttributePresentInList(SchemaAttribute schemaAttribute, List<SchemaAttribute> attributes) {
        for (SchemaAttribute attribute : attributes) {
            boolean isPresentInList = attribute.getFullResourceName().startsWith(schemaAttribute.getFullResourceName()) || schemaAttribute.getFullResourceName().startsWith(attribute.getFullResourceName());
            if (!isPresentInList) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludedAttributePresentInList(SchemaAttribute schemaAttribute, List<SchemaAttribute> excludedAttributes) {
        for (SchemaAttribute attribute : excludedAttributes) {
            boolean isPresentInList = attribute.getFullResourceName().equals(schemaAttribute.getFullResourceName());
            if (!isPresentInList) continue;
            return true;
        }
        return false;
    }

    private static void overrideEmptyReferenceNode(SchemaAttribute schemaAttribute, JsonNode attribute, BiFunction<String, String, String> referenceUrlSupplier) {
        boolean hasReferenceSubAttribute = schemaAttribute.getSubAttributes().stream().anyMatch(attr -> attr.getName().equals("$ref") && attr.getType().equals((Object)Type.REFERENCE) && attr.getReferenceTypes().contains(ReferenceTypes.RESOURCE));
        if (!hasReferenceSubAttribute) {
            return;
        }
        if (schemaAttribute.isMultiValued() && attribute.isArray()) {
            for (JsonNode complexNode : attribute) {
                ResponseAttributeValidator.overrideEmptyReferenceNodeInComplex(schemaAttribute, (ObjectNode)complexNode, referenceUrlSupplier);
            }
        } else if (attribute.isObject()) {
            ResponseAttributeValidator.overrideEmptyReferenceNodeInComplex(schemaAttribute, (ObjectNode)attribute, referenceUrlSupplier);
        }
    }

    private static void overrideEmptyReferenceNodeInComplex(SchemaAttribute schemaAttribute, ObjectNode complexAttribute, BiFunction<String, String, String> referenceUrlSupplier) {
        JsonNode refNode = complexAttribute.get("$ref");
        if (refNode != null && !refNode.isNull()) {
            return;
        }
        Optional<SchemaAttribute> valueAttribute = schemaAttribute.getSubAttributes().stream().filter(attr -> attr.getName().equals("value")).findAny();
        Optional<SchemaAttribute> typeAttribute = schemaAttribute.getSubAttributes().stream().filter(attr -> attr.getName().equals("type")).findAny();
        if (!valueAttribute.isPresent() || !typeAttribute.isPresent()) {
            return;
        }
        String resourceId = Optional.ofNullable(complexAttribute.get(valueAttribute.get().getName())).map(JsonNode::textValue).orElse(null);
        String resourceName = Optional.ofNullable(complexAttribute.get(typeAttribute.get().getName())).map(JsonNode::textValue).orElse(null);
        if (StringUtils.isBlank((CharSequence)resourceId)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            return;
        }
        String referenceUrl = referenceUrlSupplier.apply(resourceId, resourceName);
        if (referenceUrl == null) {
            return;
        }
        ScimTextNode newReferencenode = new ScimTextNode(schemaAttribute, referenceUrl);
        complexAttribute.set("$ref", (JsonNode)newReferencenode);
    }
}

