/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(RequestAttributeValidator.class);

    RequestAttributeValidator() {
    }

    public static Optional<JsonNode> validateAttribute(ServiceProvider serviceProvider, SchemaAttribute schemaAttribute, JsonNode attribute, HttpMethod httpMethod) {
        ContextValidator requestContextValidator = RequestAttributeValidator.getContextValidator(serviceProvider, httpMethod);
        Optional<JsonNode> validatedNode = ValidationSelector.validateNode(schemaAttribute, attribute, requestContextValidator);
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            try {
                RequestAttributeValidator.validateRequiredAttribute(httpMethod, schemaAttribute, !validatedNode.isPresent());
            }
            catch (AttributeValidationException ex) {
                String errorMessage = String.format("The required attribute '%s' was evaluated to an empty during schema validation but the attribute is required '%s'", schemaAttribute.getFullResourceName(), attribute);
                throw new AttributeValidationException(schemaAttribute, errorMessage, ex);
            }
        }
        return validatedNode;
    }

    private static ContextValidator getContextValidator(ServiceProvider serviceProvider, final HttpMethod httpMethod) {
        return new ContextValidator(serviceProvider, ContextValidator.ValidationContextType.REQUEST){

            @Override
            public boolean validateContext(SchemaAttribute schemaAttribute, JsonNode attribute) throws AttributeValidationException {
                boolean isNodeNull;
                if (Mutability.READ_ONLY.equals((Object)schemaAttribute.getMutability())) {
                    if (attribute != null && !attribute.isNull()) {
                        log.debug("Removing '{}' attribute '{}' from request document", (Object)Mutability.READ_ONLY, (Object)schemaAttribute.getScimNodeName());
                    }
                    return false;
                }
                boolean bl = isNodeNull = attribute == null || attribute.isNull();
                if (!schemaAttribute.isRequired()) {
                    return !isNodeNull;
                }
                RequestAttributeValidator.validateRequiredAttribute(httpMethod, schemaAttribute, isNodeNull);
                return true;
            }
        };
    }

    private static void validateRequiredAttribute(HttpMethod httpMethod, SchemaAttribute schemaAttribute, boolean isNodeNull) {
        if (!schemaAttribute.isRequired()) {
            return;
        }
        if ((Mutability.READ_WRITE.equals((Object)schemaAttribute.getMutability()) || Mutability.WRITE_ONLY.equals((Object)schemaAttribute.getMutability())) && isNodeNull) {
            String errorMessage = String.format("Required '%s' attribute '%s' is missing", schemaAttribute.getMutability(), schemaAttribute.getFullResourceName());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
        if (Mutability.IMMUTABLE.equals((Object)schemaAttribute.getMutability()) && HttpMethod.POST.equals((Object)httpMethod) && isNodeNull) {
            String errorMessage = String.format("Required '%s' attribute '%s' must be set on object creation", schemaAttribute.getMutability(), schemaAttribute.getFullResourceName());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }
}

