/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsAzurePatchValueSubAttributeRebuilder {
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchValueSubAttributeRebuilder.class);
    private final PatchOp patchOp;
    private final List<String> patchValues;

    public List<String> fixValues() {
        if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
            log.trace("[MS Azure value-subAttribute workaround] only handling 'REPLACE' and 'ADD' requests");
            return this.patchValues;
        }
        if (this.patchValues == null || this.patchValues.isEmpty()) {
            log.trace("[MS Azure value-subAttribute workaround] not executed for values-list is empty");
            return this.patchValues;
        }
        ArrayList<String> fixedValues = new ArrayList<String>();
        for (String patchValue : this.patchValues) {
            JsonNode innerObjectNode;
            JsonNode jsonNode;
            try {
                jsonNode = JsonHelper.readJsonDocument((String)patchValue);
            }
            catch (Exception ex) {
                log.trace("[MS Azure value-subAttribute workaround] ignored value-node because it is no valid JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            boolean isObjectNode = jsonNode instanceof ObjectNode;
            if (!isObjectNode) {
                log.trace("[MS Azure value-subAttribute workaround] ignored value because it is no JSON-ObjectNode");
                fixedValues.add(patchValue);
                continue;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.size() != 1) {
                log.trace("[MS Azure value-subAttribute workaround] ignored JSON-ObjectNode because it has less or more than 1 sub-nodes");
                fixedValues.add(patchValue);
                continue;
            }
            JsonNode innerValueNode = objectNode.get("value");
            if (innerValueNode == null) {
                log.trace("[MS Azure value-subAttribute workaround] ignored JSON-ObjectNode because it has no value-node");
                fixedValues.add(patchValue);
                continue;
            }
            try {
                innerObjectNode = JsonHelper.readJsonDocument((String)innerValueNode.textValue());
            }
            catch (Exception ex) {
                log.trace("[MS Azure value-subAttribute workaround] ignored inner value-node because it is no valid JSON-node");
                fixedValues.add(patchValue);
                continue;
            }
            isObjectNode = innerObjectNode instanceof ObjectNode;
            if (!isObjectNode) {
                log.trace("[MS Azure value-subAttribute workaround] ignored inner value-node because it is no not a JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            fixedValues.add(innerObjectNode.toString());
        }
        return fixedValues;
    }

    public MsAzurePatchValueSubAttributeRebuilder(PatchOp patchOp, List<String> patchValues) {
        this.patchOp = patchOp;
        this.patchValues = patchValues;
    }
}

