/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsAzurePatchComplexValueRebuilder {
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchComplexValueRebuilder.class);
    private final SchemaAttribute referencedAttribute;
    private final List<String> patchValues;

    public List<String> fixValues() {
        if (!Type.COMPLEX.equals((Object)this.referencedAttribute.getType())) {
            log.trace("[MS Azure complex-patch-path-value workaround] ignoring non-complex attribute {}", (Object)this.referencedAttribute.getScimNodeName());
            return this.patchValues;
        }
        ArrayList<String> fixedValues = new ArrayList<String>();
        for (int i = 0; i < this.patchValues.size(); ++i) {
            JsonNode jsonNode;
            String patchValue = this.patchValues.get(i);
            try {
                jsonNode = JsonHelper.readJsonDocument((String)patchValue);
            }
            catch (Exception ex) {
                log.trace("[MS Azure complex-patch-path-value workaround] ignored value-node because it is no valid JSON object-node");
                fixedValues.add(patchValue);
                continue;
            }
            if (jsonNode.isObject() || jsonNode.isArray()) {
                log.trace("[MS Azure complex-patch-path-value workaround] ignoring non-simple-value for attribute {}", (Object)this.referencedAttribute.getScimNodeName());
                fixedValues.add(patchValue);
                continue;
            }
            log.trace("[MS Azure complex-patch-path-value workaround] replacing simple-value with objectNode on attribute {}", (Object)this.referencedAttribute.getScimNodeName());
            ScimObjectNode complexObjectNode = new ScimObjectNode(this.referencedAttribute);
            complexObjectNode.set("value", (JsonNode)new TextNode(patchValue));
            fixedValues.add(complexObjectNode.toString());
        }
        return fixedValues;
    }

    public MsAzurePatchComplexValueRebuilder(SchemaAttribute referencedAttribute, List<String> patchValues) {
        this.referencedAttribute = referencedAttribute;
        this.patchValues = patchValues;
    }
}

