/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkget;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.ResourceReference;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class BulkResourceReferenceSimple
implements ResourceReference {
    private final String resourceId;
    private final ResourceType resourceType;
    private final String nodePath;

    public BulkResourceReferenceSimple(ResourceTypeFactory resourceTypeFactory, ResourceType parentResourceType, String nodePath, JsonNode nodeReference) {
        this.resourceId = Optional.ofNullable(nodeReference).map(JsonNode::textValue).orElse(null);
        this.nodePath = nodePath;
        this.resourceType = parentResourceType.getAllSchemas().stream().map(schema -> schema.getSchemaAttribute(nodePath)).filter(Objects::nonNull).findFirst().flatMap(SchemaAttribute::getResourceTypeReferenceName).flatMap(resourceTypeFactory::getResourceTypeByName).orElse(null);
    }

    @Override
    public boolean isResourceRetrievable() {
        return this.resourceType != null && StringUtils.isNotBlank((CharSequence)this.resourceId);
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getNodePath() {
        return this.nodePath;
    }
}

