/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.Optional;

public class MetaAttributeValidator {
    public static Optional<JsonNode> validateAttribute(SchemaAttribute schemaAttribute, JsonNode attribute) {
        ContextValidator metaContextValidator = MetaAttributeValidator.getContextValidator();
        Optional<JsonNode> validatedNode = ValidationSelector.validateNode(schemaAttribute, attribute, metaContextValidator);
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            try {
                MetaAttributeValidator.validateRequiredAttribute(schemaAttribute, !validatedNode.isPresent());
            }
            catch (AttributeValidationException ex) {
                String errorMessage = String.format("The required attribute '%s' was evaluated to an empty during schema validation but the attribute is required '%s'", schemaAttribute.getFullResourceName(), attribute);
                throw new AttributeValidationException(schemaAttribute, errorMessage, ex);
            }
        }
        return validatedNode;
    }

    private static void validateRequiredAttribute(SchemaAttribute schemaAttribute, boolean isNodeNull) {
        if (!schemaAttribute.isRequired()) {
            return;
        }
        if (isNodeNull) {
            String errorMessage = String.format("The required attribue '%s' is missing", schemaAttribute.getFullResourceName());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static ContextValidator getContextValidator() {
        return new ContextValidator(null, null){

            @Override
            public boolean validateContext(SchemaAttribute schemaAttribute, JsonNode jsonNode) throws AttributeValidationException {
                boolean isNodeNull = jsonNode == null || jsonNode.isNull();
                MetaAttributeValidator.validateRequiredAttribute(schemaAttribute, isNodeNull);
                return !isNodeNull;
            }
        };
    }
}

