/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultValueHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultValueHandler.class);

    public static JsonNode getOrGetDefault(SchemaAttribute schemaAttribute, JsonNode attribute) {
        String defaultValue = schemaAttribute.getDefaultValue();
        boolean isDefaultValueAssigned = StringUtils.isNotBlank((CharSequence)defaultValue);
        if (!isDefaultValueAssigned || Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            return attribute;
        }
        if (attribute != null && !attribute.isNull()) {
            return attribute;
        }
        JsonNode defaultNode = DefaultValueHandler.toJsonNode(schemaAttribute, defaultValue);
        return defaultNode;
    }

    private static JsonNode toJsonNode(SchemaAttribute schemaAttribute, String defaultValue) {
        switch (schemaAttribute.getType()) {
            case BOOLEAN: {
                return new ScimBooleanNode(schemaAttribute, Boolean.parseBoolean(defaultValue));
            }
            case INTEGER: {
                return new ScimIntNode(schemaAttribute, Integer.parseInt(defaultValue));
            }
            case DECIMAL: {
                return new ScimDoubleNode(schemaAttribute, Double.parseDouble(defaultValue));
            }
            case STRING: 
            case REFERENCE: 
            case DATE_TIME: {
                return new ScimTextNode(schemaAttribute, defaultValue);
            }
        }
        throw new InternalServerException(String.format("Invalid configuration. Default values are only supported for the following types: %s", Arrays.asList(Type.BOOLEAN, Type.INTEGER, Type.DECIMAL, Type.STRING, Type.REFERENCE, Type.DATE_TIME)));
    }

    private DefaultValueHandler() {
    }
}

