/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.DefaultValueHandler;

abstract class ContextValidator {
    private final ServiceProvider serviceProvider;
    private final ValidationContextType validationContextType;

    public abstract boolean validateContext(SchemaAttribute var1, JsonNode var2) throws AttributeValidationException;

    public JsonNode handleDefaultValue(SchemaAttribute schemaAttribute, JsonNode jsonNode) {
        boolean handleOnResponse;
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType()) || jsonNode != null && !jsonNode.isNull()) {
            return jsonNode;
        }
        boolean handleOnRequest = ValidationContextType.REQUEST.equals((Object)this.validationContextType) && this.serviceProvider.isUseDefaultValuesOnRequest();
        boolean bl = handleOnResponse = ValidationContextType.RESPONSE.equals((Object)this.validationContextType) && this.serviceProvider.isUseDefaultValuesOnResponse();
        if (handleOnRequest || handleOnResponse) {
            return DefaultValueHandler.getOrGetDefault(schemaAttribute, jsonNode);
        }
        return jsonNode;
    }

    public ContextValidator(ServiceProvider serviceProvider, ValidationContextType validationContextType) {
        this.serviceProvider = serviceProvider;
        this.validationContextType = validationContextType;
    }

    public static enum ValidationContextType {
        REQUEST,
        RESPONSE;

    }
}

