/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.server.schemas.DocumentDescription;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractSchemaValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceValidator {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceValidator.class);
    private final ResourceType resourceType;
    private final AbstractSchemaValidator schemaValidator;

    public AbstractResourceValidator(ResourceType resourceType, AbstractSchemaValidator schemaValidator) {
        this.resourceType = resourceType;
        this.schemaValidator = schemaValidator;
    }

    protected abstract int getHttpStatusCode();

    public ScimObjectNode validateDocument(JsonNode document) {
        try {
            DocumentDescription documentDescription = new DocumentDescription(this.resourceType, document);
            Schema documentSchema = documentDescription.getMetaSchema();
            ResourceNode validatedResource = (ResourceNode)this.schemaValidator.validateDocument(documentSchema, document);
            validatedResource.addSchema(documentDescription.getMetaSchema().getNonNullId());
            List<Schema> inResourcePresentExtensions = documentDescription.getExtensions();
            List<ValidatedExtension> validatedExtensions = this.validateExtensions(this.resourceType.getRequiredResourceSchemaExtensions(), inResourcePresentExtensions, document);
            for (ValidatedExtension validatedExtension : validatedExtensions) {
                if (!validatedExtension.getValidatedExtension().isEmpty()) {
                    validatedResource.addSchema(validatedExtension.getExtensionSchema().getNonNullId());
                    validatedResource.set(validatedExtension.getExtensionSchema().getNonNullId(), (JsonNode)validatedExtension.getValidatedExtension());
                    continue;
                }
                validatedResource.removeSchema(validatedExtension.getExtensionSchema().getNonNullId());
            }
            return validatedResource;
        }
        catch (AttributeValidationException ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            String errorMessage = Optional.ofNullable(cause).map(Throwable::getMessage).orElse(ex.getMessage());
            throw new DocumentValidationException(errorMessage, (Throwable)ex, Integer.valueOf(this.getHttpStatusCode()), null);
        }
        catch (DocumentValidationException ex) {
            ex.setStatus(this.getHttpStatusCode());
            throw ex;
        }
    }

    protected List<ValidatedExtension> validateExtensions(List<Schema> extensions, List<Schema> inResourcePresentExtensions, JsonNode resource) {
        ArrayList<ValidatedExtension> validatedExtensionList = new ArrayList<ValidatedExtension>();
        this.checkForMissingRequiredExtensions(extensions, inResourcePresentExtensions);
        for (Schema extensionSchema : inResourcePresentExtensions) {
            log.trace("Validating extension '{}'", (Object)extensionSchema.getNonNullId());
            JsonNode extension = resource.get(extensionSchema.getNonNullId());
            ScimObjectNode validatedExtension = this.schemaValidator.validateDocument(new ScimObjectNode(), extensionSchema, extension);
            validatedExtensionList.add(new ValidatedExtension(extensionSchema, validatedExtension));
        }
        return validatedExtensionList;
    }

    protected void checkForMissingRequiredExtensions(List<Schema> requiredExtensionList, List<Schema> inResourcePresentExtensions) {
        for (Schema requiredExtension : requiredExtensionList) {
            boolean isRequiredExtensionPresent = inResourcePresentExtensions.stream().anyMatch(schema -> schema.getNonNullId().equals(requiredExtension.getNonNullId()));
            if (isRequiredExtensionPresent) continue;
            throw new DocumentValidationException(String.format("Required extension '%s' is missing", requiredExtension.getNonNullId()), Integer.valueOf(this.getHttpStatusCode()), null);
        }
    }

    protected ResourceType getResourceType() {
        return this.resourceType;
    }

    protected AbstractSchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    protected class ValidatedExtension {
        private final Schema extensionSchema;
        private final ScimObjectNode validatedExtension;

        public Schema getExtensionSchema() {
            return this.extensionSchema;
        }

        public ScimObjectNode getValidatedExtension() {
            return this.validatedExtension;
        }

        public ValidatedExtension(Schema extensionSchema, ScimObjectNode validatedExtension) {
            this.extensionSchema = extensionSchema;
            this.validatedExtension = validatedExtension;
        }
    }
}

