/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidConfigException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidResourceTypeException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaFactory;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeFeatures;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceType
extends ResourceNode {
    private static final Logger log = LoggerFactory.getLogger(ResourceType.class);
    private final SchemaFactory schemaFactory;
    private ResourceHandler resourceHandlerImpl;

    public ResourceType() {
        this.schemaFactory = null;
    }

    protected ResourceType(SchemaFactory schemaFactory, String resourceDocument) {
        this(schemaFactory, JsonHelper.readJsonDocument((String)resourceDocument));
    }

    protected ResourceType(SchemaFactory schemaFactory, JsonNode resourceTypeDocument) {
        this.schemaFactory = Objects.requireNonNull(schemaFactory);
        this.setSchemas(JsonHelper.getSimpleAttributeArray((JsonNode)resourceTypeDocument, (String)"schemas").orElse(Collections.singletonList("urn:ietf:params:scim:schemas:core:2.0:ResourceType")));
        this.setId((String)JsonHelper.getSimpleAttribute((JsonNode)resourceTypeDocument, (String)"id").orElseThrow(() -> this.getInvalidResourceException(this.missingAttrMessage("id"))));
        this.setName((String)JsonHelper.getSimpleAttribute((JsonNode)resourceTypeDocument, (String)"name").orElseThrow(() -> this.getInvalidResourceException(this.missingAttrMessage("name"))));
        this.setDescription(JsonHelper.getSimpleAttribute((JsonNode)resourceTypeDocument, (String)"description").orElse(null));
        this.setEndpoint((String)JsonHelper.getSimpleAttribute((JsonNode)resourceTypeDocument, (String)"endpoint").orElseThrow(() -> this.getInvalidResourceException(this.missingAttrMessage("endpoint"))));
        this.setSchema((String)JsonHelper.getSimpleAttribute((JsonNode)resourceTypeDocument, (String)"schema").orElseThrow(() -> this.getInvalidResourceException(this.missingAttrMessage("schema"))));
        ArrayList<SchemaExtension> schemaExtensions = new ArrayList<SchemaExtension>();
        JsonHelper.getArrayAttribute((JsonNode)resourceTypeDocument, (String)"schemaExtensions").ifPresent(jsonNodes -> {
            for (JsonNode jsonNode : jsonNodes) {
                schemaExtensions.add(new SchemaExtension(jsonNode));
            }
        });
        this.setSchemaExtensions(schemaExtensions);
        Meta meta = this.getMetaNode(resourceTypeDocument);
        this.setMeta(meta);
        JsonNode featureNode = resourceTypeDocument.get("urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures");
        ResourceTypeFeatures resourceTypeFeatures = (ResourceTypeFeatures)JsonHelper.copyResourceToObject((JsonNode)featureNode, ResourceTypeFeatures.class);
        this.setFeatures(resourceTypeFeatures);
    }

    private Meta getMetaNode(JsonNode resourceTypeDocument) {
        Meta meta;
        Optional metaNode = JsonHelper.getObjectAttribute((JsonNode)resourceTypeDocument, (String)"meta");
        String resourceType = "ResourceType";
        if (metaNode.isPresent()) {
            meta = (Meta)JsonHelper.copyResourceToObject((JsonNode)((JsonNode)metaNode.get()), Meta.class);
            meta = Meta.builder().resourceType(meta.getResourceType().orElse("ResourceType")).location((String)meta.getLocation().orElse(null)).created(meta.getCreated().map(instant -> instant.atZone(ZoneId.systemDefault()).toLocalDateTime()).orElse(LocalDateTime.now())).lastModified(meta.getLastModified().map(instant -> instant.atZone(ZoneId.systemDefault()).toLocalDateTime()).orElse(LocalDateTime.now())).build();
        } else {
            meta = Meta.builder().resourceType("ResourceType").created(LocalDateTime.now()).lastModified(LocalDateTime.now()).build();
        }
        return meta;
    }

    public Schema getMainSchema() {
        return this.schemaFactory.getResourceSchema(this.getSchema());
    }

    public List<Schema> getAllSchemaExtensions() {
        return this.getSchemaExtensions().stream().map(SchemaExtension::getSchema).map(this.getSchemaFactory()::getResourceSchema).collect(Collectors.toList());
    }

    public List<Schema> getRequiredResourceSchemaExtensions() {
        return this.getSchemaExtensions().stream().filter(SchemaExtension::isRequired).map(SchemaExtension::getSchema).map(this.getSchemaFactory()::getResourceSchema).collect(Collectors.toList());
    }

    public Schema getMetaSchema() {
        return this.schemaFactory.getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:Meta");
    }

    public Optional<SchemaAttribute> getSchemaAttribute(String scimNodeName) {
        SchemaAttribute schemaAttribute = this.getMainSchema().getSchemaAttribute(scimNodeName);
        if (schemaAttribute != null) {
            return Optional.of(schemaAttribute);
        }
        for (Schema extension : this.getAllSchemaExtensions()) {
            SchemaAttribute schemaAttribute2 = extension.getSchemaAttribute(scimNodeName);
            if (schemaAttribute2 == null) continue;
            return Optional.of(schemaAttribute2);
        }
        return Optional.empty();
    }

    private boolean isExtensionRequired(String schemaUri) {
        return this.getSchemaExtensions().stream().filter(schemaExtension -> schemaExtension.getSchema().equals(schemaUri)).anyMatch(SchemaExtension::isRequired);
    }

    public List<Schema> getNotRequiredResourceSchemaExtensions() {
        return this.getSchemaExtensions().stream().filter(schemaExtension -> !schemaExtension.isRequired()).map(SchemaExtension::getSchema).map(this.getSchemaFactory()::getResourceSchema).collect(Collectors.toList());
    }

    public List<Schema> getAllSchemas() {
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        Schema resourceSchema = this.schemaFactory.getResourceSchema(this.getSchema());
        if (resourceSchema == null) {
            String error = String.format("Noticed a mismatch of referenced schema in resource-type definition and actual registration. SchemaId in resource-type definition '%s' was not found in schema factory. Registered schemas are: %s", this.getSchema(), this.schemaFactory.getResourceSchemas().keySet());
            throw new InvalidConfigException(error);
        }
        schemaList.add(resourceSchema);
        this.getSchemaExtensions().forEach(schemaExtension -> schemaList.add(this.schemaFactory.getResourceSchema(schemaExtension.getSchema())));
        schemaList.add(this.schemaFactory.getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:Meta"));
        return schemaList;
    }

    public final Schema getSchemaByUri(String schemaUri) {
        boolean doesUriBelongToResourceType;
        boolean bl = doesUriBelongToResourceType = schemaUri.equals(this.getSchema()) || this.getSchemaExtensions().stream().anyMatch(extension -> extension.getSchema().equals(schemaUri));
        if (!doesUriBelongToResourceType) {
            throw new BadRequestException(String.format("Schema URI '%s' is not part of resource type '%s'", schemaUri, this.getName()));
        }
        return this.schemaFactory.getResourceSchema(schemaUri);
    }

    private String missingAttrMessage(String attributeName) {
        return "missing '" + attributeName + "' attribute in resource type with name '" + this.getName() + "'";
    }

    private ScimException getInvalidResourceException(String message) {
        return new InvalidResourceTypeException(message, null, Integer.valueOf(500), null);
    }

    public void setId(String id) {
        if (this.getId().isPresent()) {
            throw new InternalServerException("the id attribute is immutable", null, null);
        }
        super.setId(id);
    }

    public String getEndpoint() {
        return (String)this.getStringAttribute("endpoint").orElseThrow(() -> new InvalidResourceTypeException("the endpoint is a required attribute", null, null, null));
    }

    private void setEndpoint(String endpoint) {
        this.setAttribute("endpoint", Objects.requireNonNull(StringUtils.stripToNull((String)endpoint)));
    }

    public String getName() {
        return (String)this.getStringAttribute("name").orElseThrow(() -> new InvalidResourceTypeException("the name is a required attribute", null, null, null));
    }

    private void setName(String name) {
        this.setAttribute("name", name);
    }

    public Optional<String> getDescription() {
        return this.getStringAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public String getSchema() {
        return (String)this.getStringAttribute("schema").orElseThrow(() -> new InvalidResourceTypeException("the schema is a required attribute", null, null, null));
    }

    private void setSchema(String schema) {
        this.setAttribute("schema", schema);
    }

    public List<SchemaExtension> getSchemaExtensions() {
        return this.getArrayAttribute("schemaExtensions", SchemaExtension.class);
    }

    private void setSchemaExtensions(List<SchemaExtension> schemaExtensions) {
        this.setAttribute("schemaExtensions", schemaExtensions);
    }

    public ResourceTypeFeatures getFeatures() {
        ResourceTypeFeatures filterExtension = this.getObjectAttribute("urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures", ResourceTypeFeatures.class).orElse(null);
        if (filterExtension == null) {
            filterExtension = ResourceTypeFeatures.builder().autoFiltering(false).singletonEndpoint(false).build();
            this.setFeatures(filterExtension);
        }
        return filterExtension;
    }

    public void setFeatures(ResourceTypeFeatures filterExtension) {
        this.setAttribute("urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures", (ObjectNode)filterExtension);
        if (filterExtension == null) {
            this.removeSchema("urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures");
        } else {
            this.addSchema("urn:gold:params:scim:schemas:extension:url:2.0:ResourceTypeFeatures");
        }
    }

    public boolean isDisabled() {
        return this.getFeatures().isResourceTypeDisabled();
    }

    public void setDisabled(Boolean disabled) {
        this.getFeatures().setResourceTypeDisabled(disabled);
    }

    protected SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public ResourceHandler getResourceHandlerImpl() {
        return this.resourceHandlerImpl;
    }

    public void setResourceHandlerImpl(ResourceHandler resourceHandlerImpl) {
        this.resourceHandlerImpl = resourceHandlerImpl;
    }

    public class SchemaExtension
    extends ScimObjectNode {
        public SchemaExtension(JsonNode jsonNode) {
            super(null);
            this.setSchema((String)JsonHelper.getSimpleAttribute((JsonNode)jsonNode, (String)"schema").orElseThrow(() -> ResourceType.this.getInvalidResourceException(ResourceType.this.missingAttrMessage("schema"))));
            this.setRequired((Boolean)JsonHelper.getSimpleAttribute((JsonNode)jsonNode, (String)"required", Boolean.class).orElseThrow(() -> ResourceType.this.getInvalidResourceException(ResourceType.this.missingAttrMessage("required"))));
        }

        public String getSchema() {
            return (String)this.getStringAttribute("schema").orElseThrow(() -> new InvalidResourceTypeException("the schema attribute is a required attribute", null, null, null));
        }

        private void setSchema(String schema) {
            this.setAttribute("schema", schema);
        }

        public boolean isRequired() {
            return (Boolean)this.getBooleanAttribute("required").orElseThrow(() -> new InvalidResourceTypeException("the required attribute is a required attribute", null, null, null));
        }

        private void setRequired(boolean required) {
            this.setAttribute("required", required);
        }
    }
}

