/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;

public class MsAzurePatchExtensionResourceRebuilder {
    private final ResourceType resourceType;

    public JsonNode rebuildResource(ResourceType.SchemaExtension extensionReference, String key, JsonNode value) {
        Schema extensionSchema = this.resourceType.getSchemaByUri(extensionReference.getSchema());
        SchemaAttribute schemaAttribute = extensionSchema.getSchemaAttribute(key);
        if (schemaAttribute == null) {
            throw new BadRequestException(String.format("Attribute '%s' is unknown to resource type '%s'", key, this.resourceType.getName()));
        }
        boolean isComplex = Type.COMPLEX.equals((Object)schemaAttribute.getType());
        boolean isMultivalued = schemaAttribute.isMultiValued();
        if (isMultivalued) {
            throw new BadRequestException(String.format("Unsupported patch operation with key-reference: %s", key));
        }
        if (isComplex) {
            return this.rebuildObjectNode(schemaAttribute, value);
        }
        return this.rebuildSimpleNode(schemaAttribute, key, value);
    }

    private JsonNode rebuildSimpleNode(SchemaAttribute schemaAttribute, String key, JsonNode value) {
        boolean isSubvalueOfComplex;
        boolean bl = isSubvalueOfComplex = schemaAttribute.getParent() != null && Type.COMPLEX.equals((Object)schemaAttribute.getParent().getType()) && !schemaAttribute.isMultiValued();
        if (isSubvalueOfComplex) {
            return this.resolveSimpleComplexSubAttribute(schemaAttribute, value);
        }
        if (value.isArray() || value.isObject()) {
            throw new BadRequestException(String.format("Invalid value '%s' found for attribute '%s'", value, key));
        }
        ObjectNode extensionNode = new ObjectNode(JsonNodeFactory.instance);
        extensionNode.set(schemaAttribute.getName(), value);
        return extensionNode;
    }

    private JsonNode resolveSimpleComplexSubAttribute(SchemaAttribute schemaAttribute, JsonNode value) {
        ObjectNode extensionNode = new ObjectNode(JsonNodeFactory.instance);
        ObjectNode complexNode = new ObjectNode(JsonNodeFactory.instance);
        extensionNode.set(schemaAttribute.getParent().getName(), (JsonNode)complexNode);
        complexNode.set(schemaAttribute.getName(), value);
        return extensionNode;
    }

    private JsonNode rebuildObjectNode(SchemaAttribute schemaAttribute, JsonNode value) {
        ObjectNode valueNode = new ObjectNode(JsonNodeFactory.instance);
        if (!value.isObject()) {
            throw new BadRequestException(String.format("Value for attribute '%s' must be an object but was '%s'", schemaAttribute.getFullResourceName(), value));
        }
        valueNode.set(schemaAttribute.getName(), value);
        return valueNode;
    }

    public MsAzurePatchExtensionResourceRebuilder(ResourceType resourceType) {
        this.resourceType = resourceType;
    }
}

