/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.server.filter.AndExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.AttributeExpressionLeaf;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.NotExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.OrExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.resources.FilterResourceResolver;
import java.util.Optional;

public class PatchFilterResolver {
    public Optional<ObjectNode> isNodeMatchingFilter(ObjectNode complexNode, FilterNode path) {
        if (complexNode == null) {
            return Optional.empty();
        }
        if (AttributePathRoot.class.isAssignableFrom(path.getClass())) {
            AttributePathRoot attributePathRoot = (AttributePathRoot)path;
            if (attributePathRoot.getChild() == null) {
                return Optional.of(complexNode);
            }
            return this.isNodeMatchingFilter(complexNode, attributePathRoot.getChild());
        }
        if (AttributeExpressionLeaf.class.isAssignableFrom(path.getClass())) {
            return this.resolveExpression(complexNode, (AttributeExpressionLeaf)path);
        }
        if (NotExpressionNode.class.isAssignableFrom(path.getClass())) {
            NotExpressionNode notExpressionNode = (NotExpressionNode)path;
            Optional<ObjectNode> matchingNode = this.isNodeMatchingFilter(complexNode, notExpressionNode.getRightNode());
            if (matchingNode.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(complexNode);
        }
        if (OrExpressionNode.class.isAssignableFrom(path.getClass())) {
            OrExpressionNode orExpressionNode = (OrExpressionNode)path;
            Optional<ObjectNode> leftNode = this.isNodeMatchingFilter(complexNode, orExpressionNode.getLeftNode());
            if (leftNode.isPresent()) {
                return leftNode;
            }
            return this.isNodeMatchingFilter(complexNode, orExpressionNode.getRightNode());
        }
        AndExpressionNode andExpressionNode = (AndExpressionNode)path;
        Optional<ObjectNode> leftNode = this.isNodeMatchingFilter(complexNode, andExpressionNode.getLeftNode());
        Optional<ObjectNode> rightNode = this.isNodeMatchingFilter(complexNode, andExpressionNode.getRightNode());
        if (leftNode.isPresent() && rightNode.isPresent()) {
            return leftNode;
        }
        return Optional.empty();
    }

    private Optional<ObjectNode> resolveExpression(ObjectNode complexNode, AttributeExpressionLeaf expressionLeaf) {
        JsonNode attribute = complexNode.get(expressionLeaf.getSchemaAttribute().getName());
        if (attribute == null) {
            return Optional.empty();
        }
        if (FilterResourceResolver.checkValueEquality(attribute, expressionLeaf)) {
            return Optional.of(complexNode);
        }
        return Optional.empty();
    }

    public boolean isSimpleNodeMatchingFilter(JsonNode simpleNode, FilterNode filterNode) {
        if (filterNode instanceof AndExpressionNode) {
            throw new BadRequestException("And expressions are not supported on simple arrayNodes");
        }
        if (filterNode instanceof OrExpressionNode) {
            throw new BadRequestException("Or expressions are not supported on simple arrayNodes");
        }
        AttributeExpressionLeaf attributeExpressionLeaf = (AttributeExpressionLeaf)filterNode;
        return FilterResourceResolver.checkValueEquality(simpleNode, attributeExpressionLeaf);
    }
}

