/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter;

import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterAttributeName;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;

public class AttributePathRoot
extends FilterNode {
    private final FilterNode child;
    private final FilterAttributeName filterAttributeName;
    private final SchemaAttribute schemaAttribute;
    private String originalExpressionString;

    public AttributePathRoot(FilterNode child, ResourceType resourceType, ScimFilterParser.ValuePathContext ctx) {
        this.child = child;
        this.filterAttributeName = new FilterAttributeName((ScimFilterParser.ValuePathContext)null, ctx.attributePath());
        this.schemaAttribute = RequestUtils.getSchemaAttributeForFilter(resourceType, this.filterAttributeName);
        this.setSubAttributeName(ctx.subattribute == null ? null : ctx.subattribute.getText());
    }

    protected AttributePathRoot() {
        this.child = null;
        this.filterAttributeName = null;
        this.schemaAttribute = null;
    }

    public String getResourceUri() {
        return this.filterAttributeName.getResourceUri();
    }

    public String getShortName() {
        return this.filterAttributeName.getShortName();
    }

    public String getFullName() {
        return this.filterAttributeName.getFullName();
    }

    public String getParentAttributeName() {
        return this.filterAttributeName.getParentAttributeName();
    }

    public String getComplexSubAttributeName() {
        return this.filterAttributeName.getComplexSubAttributeName();
    }

    public String getAttributeName() {
        return this.filterAttributeName.getAttributeName();
    }

    public String toString() {
        return this.originalExpressionString == null ? (this.child == null ? this.filterAttributeName.toString() : this.child.toString()) : this.originalExpressionString;
    }

    public FilterNode getChild() {
        return this.child;
    }

    public SchemaAttribute getSchemaAttribute() {
        return this.schemaAttribute;
    }

    public void setOriginalExpressionString(String originalExpressionString) {
        this.originalExpressionString = originalExpressionString;
    }
}

