/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestValidator;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractResourceValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ResponseResourceValidator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ResourceHandler<T extends ResourceNode> {
    private Class<T> type;
    private ServiceProvider serviceProvider;
    private ResourceType resourceType;
    private Schema schema;
    private List<Schema> schemaExtensions;
    private Supplier<Boolean> changePasswordSupported;
    private Supplier<Integer> maxResults;
    private Function<String, ResourceType> getResourceTypeByRef;

    public ResourceHandler() {
        boolean isParametrizedType;
        Class<?> clazz = this.getClass();
        Type type = clazz.getGenericSuperclass();
        do {
            if (isParametrizedType = type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                this.type = (Class)parameterizedType.getActualTypeArguments()[0];
                continue;
            }
            clazz = clazz.getSuperclass();
            type = clazz.getGenericSuperclass();
        } while (!isParametrizedType && !ResourceHandler.class.getName().equals(clazz.getName()));
        if (this.type == null) {
            throw new InternalServerException("ResourceHandler implementations must be generified!", null, null);
        }
    }

    public abstract T createResource(T var1, Context var2);

    public abstract T getResource(String var1, List<SchemaAttribute> var2, List<SchemaAttribute> var3, Context var4);

    public abstract PartialListResponse<T> listResources(long var1, int var3, FilterNode var4, SchemaAttribute var5, SortOrder var6, List<SchemaAttribute> var7, List<SchemaAttribute> var8, Context var9);

    public abstract T updateResource(T var1, Context var2);

    public abstract void deleteResource(String var1, Context var2);

    public final boolean isChangePasswordSupported() {
        return Optional.ofNullable(this.changePasswordSupported).map(Supplier::get).orElse(false);
    }

    public final int getMaxResults() {
        return Optional.ofNullable(this.maxResults).map(Supplier::get).orElse(Integer.MAX_VALUE);
    }

    public RequestValidator<T> getRequestValidator() {
        return null;
    }

    public Optional<ResourceType> getResourceTypeByRef(String ref) {
        return Optional.ofNullable(this.getResourceTypeByRef).map(function -> (ResourceType)((Object)((Object)function.apply(ref))));
    }

    protected void postConstruct(ResourceType resourceType) {
    }

    protected Optional<AbstractResourceValidator> getResponseValidator(List<SchemaAttribute> attributesList, List<SchemaAttribute> excludedAttributesList, JsonNode requestDocument, BiFunction<String, String, String> referenceUrlSupplier) {
        return Optional.of(new ResponseResourceValidator(this.serviceProvider, this.resourceType, attributesList, excludedAttributesList, requestDocument, referenceUrlSupplier));
    }

    public Class<T> getType() {
        return this.type;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    protected void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    protected void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected void setSchema(Schema schema) {
        this.schema = schema;
    }

    public List<Schema> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    protected void setSchemaExtensions(List<Schema> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
    }

    public Supplier<Boolean> getChangePasswordSupported() {
        return this.changePasswordSupported;
    }

    void setChangePasswordSupported(Supplier<Boolean> changePasswordSupported) {
        this.changePasswordSupported = changePasswordSupported;
    }

    void setMaxResults(Supplier<Integer> maxResults) {
        this.maxResults = maxResults;
    }

    void setGetResourceTypeByRef(Function<String, ResourceType> getResourceTypeByRef) {
        this.getResourceTypeByRef = getResourceTypeByRef;
    }
}

