// Generated by delombok at Fri Nov 17 16:17:33 CET 2023
package de.captaingoldfish.scim.sdk.server.endpoints.handler;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;


/**
 * author Pascal Knueppel <br>
 * created at: 20.10.2019 - 12:16 <br>
 * <br>
 */
public class SchemaHandler extends ResourceHandler<Schema>
{

  /**
   * creates the error message for the not supported operations
   */
  private static final Function<String, String> ERROR_MESSAGE_SUPPLIER = operation -> {
    return "the \'" + operation + "\'-operation is not supported for Schemas";
  };

  /**
   * needed for unit tests to prevent application context pollution
   */
  private final ResourceTypeFactory resourceTypeFactory;

  /**
   * creating of schemas not supported
   */
  @Override
  public Schema createResource(Schema resource, Context context)
  {
    throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("create"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Schema getResource(String id,
                            List<SchemaAttribute> attributes,
                            List<SchemaAttribute> excludedAttributes,
                            Context context)
  {
    Schema schema = resourceTypeFactory.getAllResourceTypes()
                                       .stream()
                                       .map(ResourceType::getAllSchemas)
                                       .flatMap(Collection::stream)
                                       .distinct()
                                       .filter(s -> id.equals(s.getId().orElse(null)))
                                       .findAny()
                                       .orElse(null);
    if (schema == null)
    {
      throw new ResourceNotFoundException("a schema with the uri identifier \'" + id + "\' does not exist", null, null);
    }
    return schema;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PartialListResponse<Schema> listResources(long startIndex,
                                                   int count,
                                                   FilterNode filter,
                                                   SchemaAttribute sortBy,
                                                   SortOrder sortOrder,
                                                   List<SchemaAttribute> attributes,
                                                   List<SchemaAttribute> excludedAttributes,
                                                   Context context)
  {
    final String excludedSchema = "urn:ietf:params:scim:schemas:core:2.0:Schema";
    List<Schema> allSchemas = resourceTypeFactory.getAllResourceTypes()
                                                 .stream()
                                                 .map(ResourceType::getAllSchemas)
                                                 .flatMap(Collection::stream)
                                                 .filter(schema -> !schema.getNonNullId().equals(excludedSchema))
                                                 .distinct()
                                                 .collect(Collectors.toList());
    return PartialListResponse.<Schema> builder().resources(allSchemas).totalResults(allSchemas.size()).build();
  }

  /**
   * updating of schemas not supported
   */
  @Override
  public Schema updateResource(Schema schema, Context context)
  {
    throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("update"));
  }

  /**
   * deleting of schemas not supported
   */
  @Override
  public void deleteResource(String id, Context context)
  {
    throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("delete"));
  }

  @java.lang.SuppressWarnings("all")
  public SchemaHandler(final ResourceTypeFactory resourceTypeFactory)
  {
    this.resourceTypeFactory = resourceTypeFactory;
  }
}
