// Generated by delombok at Fri Nov 17 16:17:33 CET 2023
package de.captaingoldfish.scim.sdk.server.endpoints;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import com.fasterxml.jackson.databind.JsonNode;


/**
 * author Pascal Knueppel <br>
 * created at: 04.10.2019 - 00:44 <br>
 * <br>
 * the endpoint definition is used to register new endpoints into the application context
 */
public class EndpointDefinition
{

  /**
   * the resource type definition that defines the SCIM endpoint
   */
  private JsonNode resourceType;

  /**
   * the main resource schema that represents the endpoint e.g. the User schema
   */
  private JsonNode resourceSchema;

  /**
   * the extensions that must or might be added to the resource that represents the endpoint
   */
  private List<JsonNode> resourceSchemaExtensions;

  /**
   * the implementation that handles the resources
   */
  private ResourceHandler resourceHandler;

  public EndpointDefinition(JsonNode resourceType,
                            JsonNode resourceSchema,
                            List<JsonNode> resourceSchemaExtensions,
                            ResourceHandler resourceHandler)
  {
    this.resourceType = resourceType;
    this.resourceSchema = resourceSchema;
    this.resourceSchemaExtensions = resourceSchemaExtensions == null ? new ArrayList<>() : resourceSchemaExtensions;
    this.resourceHandler = Objects.requireNonNull(resourceHandler, "the resource handler implementation is mandatory");
  }

  /**
   * the resource type definition that defines the SCIM endpoint
   */
  @java.lang.SuppressWarnings("all")
  public JsonNode getResourceType()
  {
    return this.resourceType;
  }

  /**
   * the main resource schema that represents the endpoint e.g. the User schema
   */
  @java.lang.SuppressWarnings("all")
  public JsonNode getResourceSchema()
  {
    return this.resourceSchema;
  }

  /**
   * the extensions that must or might be added to the resource that represents the endpoint
   */
  @java.lang.SuppressWarnings("all")
  public List<JsonNode> getResourceSchemaExtensions()
  {
    return this.resourceSchemaExtensions;
  }

  /**
   * the implementation that handles the resources
   */
  @java.lang.SuppressWarnings("all")
  public ResourceHandler getResourceHandler()
  {
    return this.resourceHandler;
  }

  /**
   * the resource type definition that defines the SCIM endpoint
   */
  @java.lang.SuppressWarnings("all")
  public void setResourceType(final JsonNode resourceType)
  {
    this.resourceType = resourceType;
  }

  /**
   * the main resource schema that represents the endpoint e.g. the User schema
   */
  @java.lang.SuppressWarnings("all")
  public void setResourceSchema(final JsonNode resourceSchema)
  {
    this.resourceSchema = resourceSchema;
  }

  /**
   * the extensions that must or might be added to the resource that represents the endpoint
   */
  @java.lang.SuppressWarnings("all")
  public void setResourceSchemaExtensions(final List<JsonNode> resourceSchemaExtensions)
  {
    this.resourceSchemaExtensions = resourceSchemaExtensions;
  }

  /**
   * the implementation that handles the resources
   */
  @java.lang.SuppressWarnings("all")
  public void setResourceHandler(final ResourceHandler resourceHandler)
  {
    this.resourceHandler = resourceHandler;
  }
}
