/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.custom;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypeAuthorization
extends ScimObjectNode {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeAuthorization.class);

    public ResourceTypeAuthorization(Set<String> roles, Set<String> rolesCreate, Set<String> rolesGet, Set<String> rolesUpdate, Set<String> rolesDelete) {
        this();
        this.setRoles(roles);
        this.setRolesCreate(rolesCreate);
        this.setRolesGet(rolesGet);
        this.setRolesUpdate(rolesUpdate);
        this.setRolesDelete(rolesDelete);
    }

    public Set<String> getRoles() {
        return this.getSimpleArrayAttributeSet("roles");
    }

    public void setRoles(Set<String> roles) {
        this.setStringAttributeList("roles", roles);
    }

    public void setRoles(String ... roles) {
        this.setStringAttributeList("roles", new HashSet<String>(Arrays.asList(roles)));
    }

    public Set<String> getRolesCreate() {
        Set<String> rolesCreate = this.getSimpleArrayAttributeSet("rolesCreate");
        if (rolesCreate.isEmpty()) {
            rolesCreate = this.getRoles();
        }
        return rolesCreate;
    }

    public void setRolesCreate(Set<String> rolesCreate) {
        this.setStringAttributeList("rolesCreate", rolesCreate);
    }

    public void setRolesCreate(String ... rolesCreate) {
        this.setStringAttributeList("rolesCreate", new HashSet<String>(Arrays.asList(rolesCreate)));
    }

    public Set<String> getRolesGet() {
        Set<String> rolesGet = this.getSimpleArrayAttributeSet("rolesGet");
        if (rolesGet.isEmpty()) {
            rolesGet = this.getRoles();
        }
        return rolesGet;
    }

    public void setRolesGet(Set<String> rolesGet) {
        this.setStringAttributeList("rolesGet", rolesGet);
    }

    public void setRolesGet(String ... rolesGet) {
        this.setStringAttributeList("rolesGet", new HashSet<String>(Arrays.asList(rolesGet)));
    }

    public Set<String> getRolesUpdate() {
        Set<String> rolesUpdate = this.getSimpleArrayAttributeSet("rolesUpdate");
        if (rolesUpdate.isEmpty()) {
            rolesUpdate = this.getRoles();
        }
        return rolesUpdate;
    }

    public void setRolesUpdate(String ... rolesUpdate) {
        this.setStringAttributeList("rolesUpdate", new HashSet<String>(Arrays.asList(rolesUpdate)));
    }

    public void setRolesUpdate(Set<String> rolesUpdate) {
        this.setStringAttributeList("rolesUpdate", rolesUpdate);
    }

    public Set<String> getRolesDelete() {
        Set<String> rolesDelete = this.getSimpleArrayAttributeSet("rolesDelete");
        if (rolesDelete.isEmpty()) {
            rolesDelete = this.getRoles();
        }
        return rolesDelete;
    }

    public void setRolesDelete(Set<String> rolesDelete) {
        this.setStringAttributeList("rolesDelete", rolesDelete);
    }

    public void setRolesDelete(String ... rolesDelete) {
        this.setStringAttributeList("rolesDelete", new HashSet<String>(Arrays.asList(rolesDelete)));
    }

    public static ResourceTypeAuthorizationBuilder builder() {
        return new ResourceTypeAuthorizationBuilder();
    }

    public ResourceTypeAuthorization() {
    }

    public static class ResourceTypeAuthorizationBuilder {
        private Set<String> roles;
        private Set<String> rolesCreate;
        private Set<String> rolesGet;
        private Set<String> rolesUpdate;
        private Set<String> rolesDelete;

        ResourceTypeAuthorizationBuilder() {
        }

        public ResourceTypeAuthorizationBuilder roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public ResourceTypeAuthorizationBuilder rolesCreate(Set<String> rolesCreate) {
            this.rolesCreate = rolesCreate;
            return this;
        }

        public ResourceTypeAuthorizationBuilder rolesGet(Set<String> rolesGet) {
            this.rolesGet = rolesGet;
            return this;
        }

        public ResourceTypeAuthorizationBuilder rolesUpdate(Set<String> rolesUpdate) {
            this.rolesUpdate = rolesUpdate;
            return this;
        }

        public ResourceTypeAuthorizationBuilder rolesDelete(Set<String> rolesDelete) {
            this.rolesDelete = rolesDelete;
            return this;
        }

        public ResourceTypeAuthorization build() {
            return new ResourceTypeAuthorization(this.roles, this.rolesCreate, this.rolesGet, this.rolesUpdate, this.rolesDelete);
        }

        public String toString() {
            return "ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder(roles=" + this.roles + ", rolesCreate=" + this.rolesCreate + ", rolesGet=" + this.rolesGet + ", rolesUpdate=" + this.rolesUpdate + ", rolesDelete=" + this.rolesDelete + ")";
        }
    }
}

