/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidSchemaException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaValidator;
import java.util.HashMap;
import java.util.Map;

public final class SchemaFactory {
    private final Map<String, Schema> metaSchemas = new HashMap<String, Schema>();
    private final Map<String, Schema> resourceSchemas = new HashMap<String, Schema>();
    private ResourceTypeFactory resourceTypeFactory;

    protected SchemaFactory(ResourceTypeFactory resourceTypeFactory) {
        this.resourceTypeFactory = resourceTypeFactory;
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/schema.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/resource-type.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/service-provider.schema.json"));
        this.registerMetaSubSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/meta.schema.json"), "meta");
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/request/bulk-request.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/response/bulk-response.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/request/patch-request.json"));
    }

    private void registerMetaSchema(JsonNode jsonSchema) {
        Schema schema = new Schema(jsonSchema);
        this.metaSchemas.put(schema.getNonNullId(), schema);
    }

    private void registerMetaSubSchema(JsonNode jsonSchema, String overrideNamePrefix) {
        Schema schema = new Schema(jsonSchema, overrideNamePrefix);
        this.metaSchemas.put(schema.getNonNullId(), schema);
    }

    public void registerResourceSchema(JsonNode jsonSchema) {
        Schema metaSchema = this.getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:Schema");
        try {
            SchemaValidator.validateSchemaDocument(metaSchema, jsonSchema);
            Schema schema = new Schema(jsonSchema);
            this.resourceSchemas.put(schema.getNonNullId(), schema);
        }
        catch (DocumentValidationException ex) {
            throw new InvalidSchemaException(ex.getMessage(), (Throwable)ex, null, null);
        }
    }

    public Schema getMetaSchema(String id) {
        return this.metaSchemas.get(id);
    }

    public Schema getResourceSchema(String id) {
        return this.resourceSchemas.get(id);
    }

    protected Map<String, Schema> getMetaSchemas() {
        return this.metaSchemas;
    }

    protected Map<String, Schema> getResourceSchemas() {
        return this.resourceSchemas;
    }

    protected ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }
}

