/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidResourceTypeException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaFactory;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceTypeFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeFactory.class);
    private final Map<String, ResourceType> resourceTypes = new HashMap<String, ResourceType>();
    private SchemaFactory schemaFactory = new SchemaFactory(this);

    public ResourceType registerResourceType(ResourceHandler resourceHandler, JsonNode resourceType, JsonNode resourceSchema, JsonNode ... resourceSchemaExtensions) {
        Schema resourceTypeSchema = this.schemaFactory.getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:ResourceType");
        JsonNode validatedResourceType = SchemaValidator.validateSchemaDocument(resourceTypeSchema, resourceType);
        ResourceType resourceTypeObject = new ResourceType(this.schemaFactory, resourceType);
        this.addSchemaExtensions(validatedResourceType, resourceSchemaExtensions);
        this.checkResourceSchema(resourceTypeObject, resourceSchema);
        resourceTypeObject.setResourceHandlerImpl(resourceHandler);
        this.resourceTypes.put(resourceTypeObject.getEndpoint(), resourceTypeObject);
        return resourceTypeObject;
    }

    private void checkResourceSchema(ResourceType resourceTypeObject, JsonNode resourceSchema) {
        Schema registeredResourceSchema = this.schemaFactory.getResourceSchema(resourceTypeObject.getSchema());
        if (resourceSchema == null && registeredResourceSchema == null) {
            String errorMessage = "the resource type cannot be registered since the required resource schema '" + resourceTypeObject.getSchema() + "' is not registered yet";
            throw new InvalidResourceTypeException(errorMessage, null, null, null);
        }
        if (registeredResourceSchema != null && resourceSchema != null && !registeredResourceSchema.equals((Object)resourceSchema)) {
            log.warn("resource schema with id '{}' is already registered. The new instance that was given is not equal to the old schema document which will be overridden ", (Object)resourceTypeObject.getSchema());
        }
        if (resourceSchema != null) {
            this.schemaFactory.registerResourceSchema(resourceSchema);
        }
    }

    private void addSchemaExtensions(JsonNode resourceType, JsonNode[] resourceSchemaExtensions) {
        ArrayNode schemaExtensions = JsonHelper.getArrayAttribute((JsonNode)resourceType, (String)"schemaExtensions").orElse(null);
        Set<String> resourceTypeExtensionIds = this.getExtensionIds(schemaExtensions);
        Set<String> extensionsToRegisterIds = this.getExtensionIds(resourceSchemaExtensions);
        if (resourceTypeExtensionIds.isEmpty() && extensionsToRegisterIds.isEmpty()) {
            return;
        }
        this.validateSchemaExtensions(resourceTypeExtensionIds, extensionsToRegisterIds);
        for (JsonNode resourceSchemaExtension : resourceSchemaExtensions) {
            this.schemaFactory.registerResourceSchema(resourceSchemaExtension);
        }
    }

    private void validateSchemaExtensions(Set<String> resourceTypeExtensionIds, Set<String> extensionsToRegisterIds) {
        if (resourceTypeExtensionIds.equals(extensionsToRegisterIds)) {
            return;
        }
        this.validateUnreferencedExtensions(resourceTypeExtensionIds, extensionsToRegisterIds);
        this.validateMissingExtensions(resourceTypeExtensionIds, extensionsToRegisterIds);
    }

    private void validateMissingExtensions(Set<String> resourceTypeExtensionIds, Set<String> extensionsToRegisterIds) {
        HashSet<String> resourceTypeIds = new HashSet<String>(resourceTypeExtensionIds);
        resourceTypeIds.removeAll(extensionsToRegisterIds);
        for (String extensionId : resourceTypeIds) {
            if (this.schemaFactory.getResourceSchema(extensionId) != null) continue;
            String errorMessage = "You missed to add the extension with the id '" + extensionId + "' for registration";
            throw new InvalidResourceTypeException(errorMessage, null, null, null);
        }
    }

    private void validateUnreferencedExtensions(Set<String> resourceTypeExtensionIds, Set<String> extensionsToRegisterIds) {
        if (!resourceTypeExtensionIds.containsAll(extensionsToRegisterIds)) {
            throw new InvalidResourceTypeException("The extensions " + extensionsToRegisterIds + " are not referenced in the schemaExtensions attribute within the resource type. The referenced schemas are: " + resourceTypeExtensionIds, null, null, null);
        }
    }

    private Set<String> getExtensionIds(ArrayNode arrayNode) {
        if (arrayNode == null || arrayNode.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> resourceTypeExtensionIds = new HashSet<String>();
        for (JsonNode extension : arrayNode) {
            resourceTypeExtensionIds.add(extension.get("schema").textValue());
        }
        return resourceTypeExtensionIds;
    }

    private Set<String> getExtensionIds(JsonNode[] resourceSchemaExtensions) {
        if (resourceSchemaExtensions == null || resourceSchemaExtensions.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(resourceSchemaExtensions).map(jsonNode -> jsonNode.get("id").textValue()).collect(Collectors.toSet());
    }

    public void registerResourceType(ResourceHandler resourceHandler, String id, String name, String description, String schema, String endpoint, JsonNode resourceSchema, JsonNode ... resourceSchemaExtensions) {
        ObjectNode resourceType = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode schemasNode = new ArrayNode(JsonNodeFactory.instance);
        schemasNode.add((JsonNode)new TextNode("urn:ietf:params:scim:schemas:core:2.0:ResourceType"));
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"schemas", (JsonNode)schemasNode);
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"id", (JsonNode)new TextNode(id));
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"name", (JsonNode)new TextNode(name));
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"description", (JsonNode)new TextNode(description));
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"schema", (JsonNode)new TextNode(schema));
        JsonHelper.addAttribute((JsonNode)resourceType, (String)"endpoint", (JsonNode)new TextNode(endpoint));
        this.registerResourceType(resourceHandler, (JsonNode)resourceType, resourceSchema, resourceSchemaExtensions);
    }

    public ResourceType getResourceType(String endpoint) {
        String path = endpoint;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceTypes.get(path);
    }

    protected boolean isResourceRegistered(String resourceName) {
        return this.resourceTypes.values().stream().map(ResourceType::getName).anyMatch(resourceName::equals);
    }

    public Optional<ResourceType> getResourceTypeByName(String name) {
        return this.resourceTypes.values().stream().filter(resourceType -> resourceType.getName().equals(name)).findAny();
    }

    public Collection<ResourceType> getAllResourceTypes() {
        return this.resourceTypes.values();
    }

    protected Map<String, ResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    private void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }
}

