/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.IOException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.resources.PatchFilterResolver;
import de.captaingoldfish.scim.sdk.server.patch.AbstractPatch;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchTargetHandler
extends AbstractPatch {
    private static final Logger log = LoggerFactory.getLogger(PatchTargetHandler.class);
    private final AttributePathRoot path;
    private final PatchOp patchOp;
    private SchemaAttribute schemaAttribute;

    public PatchTargetHandler(ResourceType resourceType, PatchOp patchOp, String path) {
        super(resourceType);
        try {
            this.path = RequestUtils.parsePatchPath(resourceType, path);
        }
        catch (ScimException ex) {
            ex.setScimType("invalidPath");
            throw ex;
        }
        this.patchOp = patchOp;
        this.schemaAttribute = this.getSchemaAttribute();
    }

    private void evaluatePatchPathOperation(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (Mutability.READ_ONLY.equals((Object)schemaAttribute.getMutability())) {
            throw new BadRequestException("the attribute '" + schemaAttribute.getScimNodeName() + "' is a '" + Mutability.READ_ONLY + "' attribute and cannot be changed", null, "invalidPath");
        }
        if (!PatchOp.REMOVE.equals((Object)this.patchOp) && Mutability.IMMUTABLE.equals((Object)schemaAttribute.getMutability()) && attribute != null) {
            throw new BadRequestException("the attribute '" + schemaAttribute.getScimNodeName() + "' is '" + Mutability.IMMUTABLE + "' and is not unassigned. Current value is: " + attribute.asText(), null, "invalidPath");
        }
    }

    public boolean addOperationValues(ResourceNode resource, List<String> values) {
        JsonNode firstAttribute;
        this.validateRequest(values);
        String[] fullAttributeNames = this.getAttributeNames();
        String firstAttributeName = fullAttributeNames[0];
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(firstAttributeName);
        boolean isExtension = this.resourceType.getSchemaExtensions().stream().anyMatch(ext -> ext.getSchema().equals(schemaAttribute.getResourceUri()));
        ResourceNode currentParent = resource;
        if (isExtension) {
            this.addExtensionToSchemas(resource, this.patchOp, schemaAttribute);
            currentParent = (ObjectNode)currentParent.get(schemaAttribute.getResourceUri());
            if (currentParent == null) {
                currentParent = new ScimObjectNode();
                resource.set(schemaAttribute.getResourceUri(), (JsonNode)currentParent);
            }
        }
        if ((firstAttribute = this.getAttributeFromObject((JsonNode)currentParent, firstAttributeName)) == null && !Type.COMPLEX.equals((Object)schemaAttribute.getType()) || firstAttribute != null && !firstAttribute.isArray() && !firstAttribute.isObject()) {
            boolean changeWasMade = this.handleSimpleNode(schemaAttribute, (ObjectNode)currentParent, values);
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, (ObjectNode)currentParent);
            return changeWasMade;
        }
        if (firstAttribute != null && firstAttribute.isArray()) {
            return this.handlePatchOperationOnMultiValued(resource, values, fullAttributeNames, schemaAttribute, isExtension, (ObjectNode)currentParent, firstAttribute);
        }
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            return this.handlePatchOperationOnComplex(resource, values, fullAttributeNames, firstAttributeName, schemaAttribute, isExtension, (ObjectNode)currentParent, firstAttribute);
        }
        return false;
    }

    private boolean handlePatchOperationOnComplex(ResourceNode resource, List<String> values, String[] fullAttributeNames, String firstAttributeName, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent, JsonNode firstAttribute) {
        if (PatchOp.REMOVE.equals((Object)this.patchOp) && fullAttributeNames.length == 1 && this.path.getSubAttributeName() == null) {
            this.evaluatePatchPathOperation(schemaAttribute, firstAttribute);
            if (firstAttribute == null) {
                return false;
            }
            resource.remove(firstAttributeName);
            return true;
        }
        boolean changeMade = this.handleComplexAttribute(schemaAttribute, currentParent, fullAttributeNames, values);
        this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
        return changeMade;
    }

    private boolean handlePatchOperationOnMultiValued(ResourceNode resource, List<String> values, String[] fullAttributeNames, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent, JsonNode firstAttribute) {
        if (PatchOp.REMOVE.equals((Object)this.patchOp) && fullAttributeNames.length == 1 && this.path.getSubAttributeName() == null && this.path.getChild() == null) {
            this.evaluatePatchPathOperation(schemaAttribute, firstAttribute.isEmpty() ? null : firstAttribute);
            int sizeBefore = currentParent.size();
            JsonNode removedNode = currentParent.remove(schemaAttribute.getName());
            boolean effectiveChangeMade = false;
            if (sizeBefore > currentParent.size() && !removedNode.isEmpty()) {
                effectiveChangeMade = true;
            }
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
            return effectiveChangeMade;
        }
        boolean changeWasMade = this.handleMultiValuedAttribute(schemaAttribute, (ArrayNode)firstAttribute, fullAttributeNames, values);
        if (firstAttribute.isEmpty()) {
            resource.remove(schemaAttribute.getName());
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
        }
        return changeWasMade;
    }

    private void removeExtensionIfEmpty(ResourceNode resource, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent) {
        if (isExtension && currentParent.isEmpty()) {
            resource.remove(schemaAttribute.getResourceUri());
            resource.removeSchema(schemaAttribute.getResourceUri());
        }
    }

    private void addExtensionToSchemas(ResourceNode resource, PatchOp patchOp, SchemaAttribute schemaAttribute) {
        if (patchOp.equals((Object)PatchOp.REMOVE)) {
            return;
        }
        resource.addSchema(schemaAttribute.getResourceUri());
    }

    protected boolean handleSimpleNode(SchemaAttribute schemaAttribute, ObjectNode objectNode, List<String> values) {
        if (!PatchOp.REMOVE.equals((Object)this.patchOp) && values.size() > 1 && !schemaAttribute.isMultiValued()) {
            throw new BadRequestException("found multiple values for simple attribute '" + schemaAttribute.getFullResourceName() + "': " + String.join((CharSequence)",", values), null, "invalidValue");
        }
        JsonNode oldNode = objectNode.get(schemaAttribute.getName());
        this.evaluatePatchPathOperation(schemaAttribute, oldNode);
        if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
            if (oldNode == null) {
                return false;
            }
            objectNode.remove(schemaAttribute.getName());
            return true;
        }
        JsonNode newNode = this.createNewNode(schemaAttribute, values.get(0));
        if (!newNode.equals((Object)oldNode)) {
            objectNode.set(schemaAttribute.getName(), newNode);
            return true;
        }
        return false;
    }

    private boolean handleComplexAttribute(SchemaAttribute schemaAttribute, ObjectNode resource, String[] fullAttributeNames, List<String> values) {
        if (fullAttributeNames.length > 1) {
            ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
            this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)complexNode);
            return this.handleComplexSubAttributePathReference(schemaAttribute, resource, fullAttributeNames[1], values);
        }
        return this.handleDirectComplexPathReference(schemaAttribute, resource, values);
    }

    private boolean handleDirectComplexPathReference(SchemaAttribute schemaAttribute, ObjectNode resource, List<String> values) {
        boolean hasFilterExpression;
        ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
        this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)complexNode);
        if (values.size() != 1 || StringUtils.isBlank((CharSequence)values.get(0))) {
            throw new BadRequestException("found multiple or no values for non multi valued complex type '" + schemaAttribute.getFullResourceName() + "': \n\t" + String.join((CharSequence)",", values), null, "invalidValue");
        }
        JsonNode newNode = JsonHelper.readJsonDocument((String)values.get(0));
        if (newNode == null || !newNode.isObject()) {
            throw new BadRequestException("given value is not a complex json representation for attribute '" + schemaAttribute.getFullResourceName() + "': \n\t" + String.join((CharSequence)",", values), null, "invalidValue");
        }
        PatchFilterResolver filterResolver = new PatchFilterResolver();
        boolean bl = hasFilterExpression = this.path.getChild() != null;
        if (complexNode != null && hasFilterExpression && !filterResolver.isNodeMatchingFilter(complexNode, this.path).isPresent()) {
            return false;
        }
        boolean changeWasMade = false;
        if (PatchOp.ADD.equals((Object)this.patchOp)) {
            JsonNode oldNode = resource.get(schemaAttribute.getName());
            newNode = this.mergeObjectNodes((ObjectNode)newNode, oldNode);
            resource.set(schemaAttribute.getName(), newNode);
            changeWasMade = !newNode.equals((Object)oldNode);
        } else if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            resource.set(schemaAttribute.getName(), newNode);
            changeWasMade = true;
        }
        return changeWasMade;
    }

    private boolean handleComplexSubAttributePathReference(SchemaAttribute schemaAttribute, ObjectNode resource, String fullAttributeName, List<String> values) {
        Optional<ObjectNode> matchingNode;
        SchemaAttribute subAttribute = this.getSchemaAttribute(fullAttributeName);
        ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
        if (complexNode == null) {
            complexNode = new ScimObjectNode(schemaAttribute);
            resource.set(schemaAttribute.getName(), (JsonNode)complexNode);
        }
        if (!(matchingNode = new PatchFilterResolver().isNodeMatchingFilter(complexNode, this.path)).isPresent()) {
            if (complexNode.isEmpty()) {
                resource.remove(schemaAttribute.getName());
            }
            return false;
        }
        if (this.handleInnerComplexAttribute(subAttribute, complexNode, values)) {
            if (complexNode.isEmpty()) {
                resource.remove(schemaAttribute.getName());
            }
            return true;
        }
        if (complexNode.isEmpty()) {
            resource.remove(schemaAttribute.getName());
            return false;
        }
        JsonNode firstAttribute = resource.get(fullAttributeName);
        return firstAttribute == null || !firstAttribute.asText().equals(values.get(0));
    }

    private boolean handleInnerComplexAttribute(SchemaAttribute subAttribute, ObjectNode complexNode, List<String> values) {
        if (subAttribute.isMultiValued()) {
            ArrayNode arrayNode = (ArrayNode)complexNode.get(subAttribute.getName());
            if (arrayNode == null) {
                arrayNode = new ScimArrayNode(subAttribute);
                complexNode.set(subAttribute.getName(), (JsonNode)arrayNode);
            }
            if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
                arrayNode.removeAll();
            }
            if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
                boolean effectiveChange = !complexNode.get(subAttribute.getName()).isEmpty();
                complexNode.remove(subAttribute.getName());
                return effectiveChange;
            }
            values.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            return true;
        }
        return this.handleSimpleNode(subAttribute, complexNode, values);
    }

    private JsonNode mergeObjectNodes(ObjectNode newNode, JsonNode oldNode) {
        if (oldNode == null) {
            return newNode;
        }
        oldNode.fields().forEachRemaining(stringJsonNodeEntry -> {
            String key = (String)stringJsonNodeEntry.getKey();
            JsonNode value = (JsonNode)stringJsonNodeEntry.getValue();
            JsonNode newSubNode = newNode.get(key);
            if (newSubNode == null) {
                newNode.set(key, value);
            } else if (newSubNode.isArray()) {
                newSubNode.forEach(arg_0 -> ((ArrayNode)((ArrayNode)value)).add(arg_0));
                newNode.set(key, value);
            }
        });
        return newNode;
    }

    private boolean handleMultiValuedAttribute(SchemaAttribute schemaAttribute, ArrayNode multiValued, String[] fullAttributeNames, List<String> values) {
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            if (fullAttributeNames.length > 1) {
                return this.handleMultiComplexSubAttributePath(multiValued, fullAttributeNames[1], values);
            }
            this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)(multiValued.isEmpty() ? null : multiValued));
            return this.handleDirectMultiValuedComplexPathReference(multiValued, values);
        }
        if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            multiValued.removeAll();
        }
        for (String value : values) {
            multiValued.add(this.createNewNode(schemaAttribute, value));
        }
        return true;
    }

    private boolean handleDirectMultiValuedComplexPathReference(ArrayNode multiValued, List<String> values) {
        if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
            List<IndexNode> matchingComplexNodes = this.resolveFilter(multiValued, this.path);
            boolean changeWasMade = false;
            for (int i = 0; i < matchingComplexNodes.size(); ++i) {
                multiValued.remove(matchingComplexNodes.get(i).getIndex());
                changeWasMade = true;
            }
            return changeWasMade;
        }
        if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            multiValued.removeAll();
        }
        for (String value : values) {
            try {
                JsonNode jsonNode = JsonHelper.readJsonDocument((String)value);
                JsonNode primary = jsonNode.get("primary");
                this.checkForPrimary(multiValued, primary != null && primary.booleanValue());
                multiValued.add(jsonNode);
            }
            catch (IOException ex) {
                throw new BadRequestException("the value must be a whole complex type json structure but was: '" + value + "'", (Throwable)ex, "invalidValue");
            }
        }
        return true;
    }

    private void checkForPrimary(ArrayNode multiValued, boolean primary) {
        if (!primary) {
            return;
        }
        multiValued.forEach(jsonNode -> ((ObjectNode)jsonNode).remove("primary"));
    }

    private boolean handleMultiComplexSubAttributePath(ArrayNode multiValued, String fullAttributeName, List<String> values) {
        if (!PatchOp.REMOVE.equals((Object)this.patchOp) && multiValued.isEmpty()) {
            return false;
        }
        SchemaAttribute subAttribute = RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, fullAttributeName);
        List<IndexNode> matchingComplexNodes = this.resolveFilter(multiValued, this.path);
        AtomicBoolean changeWasMade = new AtomicBoolean(false);
        if ("primary".equals(subAttribute.getName())) {
            this.checkForPrimary(multiValued, Boolean.parseBoolean(values.get(0)));
        }
        for (int i = 0; i < matchingComplexNodes.size(); ++i) {
            ObjectNode complexNode = matchingComplexNodes.get(i).getObjectNode();
            changeWasMade.weakCompareAndSet(false, this.handleInnerComplexAttribute(subAttribute, complexNode, values));
            if (!complexNode.isEmpty()) continue;
            multiValued.remove(matchingComplexNodes.get(i).getIndex());
        }
        return changeWasMade.get();
    }

    private List<IndexNode> resolveFilter(ArrayNode multiValuedComplex, AttributePathRoot path) {
        PatchFilterResolver patchFilterResolver = new PatchFilterResolver();
        ArrayList<IndexNode> matchingComplexNodes = new ArrayList<IndexNode>();
        for (int i = 0; i < multiValuedComplex.size(); ++i) {
            JsonNode complex = multiValuedComplex.get(i);
            Optional<ObjectNode> filteredNode = patchFilterResolver.isNodeMatchingFilter((ObjectNode)complex, path);
            if (!filteredNode.isPresent()) continue;
            matchingComplexNodes.add(new IndexNode(i, filteredNode.get()));
        }
        if (path.getChild() != null && matchingComplexNodes.isEmpty()) {
            return Collections.emptyList();
        }
        return matchingComplexNodes;
    }

    private JsonNode createNewNode(SchemaAttribute schemaAttribute, String value) {
        switch (schemaAttribute.getType()) {
            case STRING: 
            case DATE_TIME: 
            case REFERENCE: {
                return new ScimTextNode(schemaAttribute, value);
            }
            case BOOLEAN: {
                return new ScimBooleanNode(schemaAttribute, Boolean.parseBoolean(value));
            }
            case INTEGER: {
                Long longVal = Long.parseLong(value);
                if (longVal == (long)longVal.intValue()) {
                    return new ScimIntNode(schemaAttribute, longVal.intValue());
                }
                return new ScimLongNode(schemaAttribute, longVal.longValue());
            }
        }
        return new ScimDoubleNode(schemaAttribute, Double.parseDouble(value));
    }

    protected void validateRequest(List<String> values) {
        this.validateAttributeType(values);
        this.validatePath(this.path, this.patchOp, values);
    }

    private void validatePath(AttributePathRoot path, PatchOp patchOp, List<String> values) {
        switch (patchOp) {
            case ADD: {
                this.checkIsValidComplexJson(path, values);
                break;
            }
            case REPLACE: {
                this.validateReplaceOperation(path, values);
                break;
            }
            case REMOVE: {
                this.validateRemoveOperation(path, values);
            }
        }
    }

    private void validateRemoveOperation(AttributePathRoot path, List<String> values) {
        if (values != null && !values.isEmpty()) {
            throw new BadRequestException("values must not be set for remove operation but was: " + String.join((CharSequence)",", values), null, "invalidValue");
        }
        if (path == null) {
            throw new BadRequestException("no target present within the request", null, "invalidPath");
        }
    }

    private void validateReplaceOperation(AttributePathRoot path, List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new BadRequestException("values parameter must be set for replace operation but was empty", null, "invalidValue");
        }
        if (StringUtils.isBlank((CharSequence)path.getSubAttributeName()) && path.getChild() != null && !values.stream().allMatch(JsonHelper::isValidJson)) {
            throw new BadRequestException("the values are expected to be valid json representations for an expression as '" + path.toString() + "' but was: " + String.join((CharSequence)",\n", values), null, "invalidPath");
        }
        this.checkIsValidComplexJson(path, values);
    }

    private void checkIsValidComplexJson(AttributePathRoot path, List<String> values) {
        String[] namePath = path.getShortName().split("\\.");
        if (path.getChild() == null && Type.COMPLEX.equals((Object)path.getSchemaAttribute().getType()) && namePath.length == 1 && !values.stream().allMatch(JsonHelper::isValidJson)) {
            throw new BadRequestException("the value parameters must be valid json representations but was\n'" + String.join((CharSequence)",\n", values) + "'", null, "invalidPath");
        }
    }

    private void validateAttributeType(List<String> values) {
        switch (this.schemaAttribute.getType()) {
            case STRING: 
            case DATE_TIME: 
            case REFERENCE: 
            case BOOLEAN: 
            case INTEGER: 
            case DECIMAL: {
                if (this.schemaAttribute.isMultiValued() || values.size() <= 1) break;
                throw new BadRequestException("several values found for non multivalued node of type '" + this.schemaAttribute.getType() + "'", null, "invalidValue");
            }
        }
    }

    private String[] getAttributeNames() {
        String attributeName = this.path.getShortName() + (StringUtils.isBlank((CharSequence)this.path.getSubAttributeName()) ? "" : "." + this.path.getSubAttributeName());
        String[] attributeNames = attributeName.split("\\.");
        String resourceUri = this.path.getResourceUri() == null ? "" : this.path.getResourceUri() + ":";
        attributeNames[0] = resourceUri + attributeNames[0];
        for (int i = 1; i < attributeNames.length; ++i) {
            attributeNames[i] = attributeNames[i - 1] + "." + attributeNames[i];
        }
        return attributeNames;
    }

    private SchemaAttribute getSchemaAttribute() {
        if (this.schemaAttribute == null) {
            this.schemaAttribute = this.getSchemaAttribute(this.path.getFullName());
        }
        return this.schemaAttribute;
    }

    protected AttributePathRoot getPath() {
        return this.path;
    }

    private static class IndexNode {
        private int index;
        private ObjectNode objectNode;

        public int getIndex() {
            return this.index;
        }

        public ObjectNode getObjectNode() {
            return this.objectNode;
        }

        public IndexNode(int index, ObjectNode objectNode) {
            this.index = index;
            this.objectNode = objectNode;
        }
    }
}

