/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.patch.AbstractPatch;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class PatchResourceHandler
extends AbstractPatch {
    private PatchOp patchOp;

    public PatchResourceHandler(ResourceType resourceType, PatchOp op) {
        super(resourceType);
        this.patchOp = op;
    }

    public boolean addResourceValues(ObjectNode resource, JsonNode readJsonDocument, String extensionUri) {
        if (readJsonDocument == null || readJsonDocument.isEmpty()) {
            throw new BadRequestException("no attributes present in value-resource in patch operation", null, "invalidValue");
        }
        AtomicBoolean changeWasMade = new AtomicBoolean(false);
        JsonHelper.removeAttribute((JsonNode)readJsonDocument, (String)"schemas");
        readJsonDocument.fields().forEachRemaining(stringJsonNodeEntry -> {
            String key = (String)stringJsonNodeEntry.getKey();
            JsonNode value = (JsonNode)stringJsonNodeEntry.getValue();
            boolean isExtension = this.resourceType.getSchemaExtensions().stream().anyMatch(ext -> ext.getSchema().equals(key));
            if (isExtension) {
                JsonNode complex = resource.get(key);
                if (complex == null) {
                    complex = new ScimObjectNode();
                    resource.set(key, complex);
                    ((ResourceNode)resource).addSchema(key);
                }
                changeWasMade.set(this.addResourceValues((ObjectNode)complex, value, key));
            } else {
                SchemaAttribute schemaAttribute = this.getSchemaAttribute((extensionUri == null ? "" : extensionUri + ":") + key);
                this.verifyImmutableAndReadOnly((JsonNode)resource, schemaAttribute);
                if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
                    changeWasMade.weakCompareAndSet(false, this.addComplexAttribute(resource, schemaAttribute, value, extensionUri));
                } else if (schemaAttribute.isMultiValued()) {
                    changeWasMade.weakCompareAndSet(false, this.addMultivaluedAttribute(resource, schemaAttribute, value));
                } else {
                    changeWasMade.weakCompareAndSet(false, this.addSimpleAttribute(resource, schemaAttribute, value));
                }
            }
        });
        return changeWasMade.get();
    }

    private void verifyImmutableAndReadOnly(JsonNode jsonNode, SchemaAttribute schemaAttribute) {
        if (Mutability.READ_ONLY.equals((Object)schemaAttribute.getMutability()) || jsonNode.get(schemaAttribute.getName()) != null && Mutability.IMMUTABLE.equals((Object)schemaAttribute.getMutability())) {
            throw new BadRequestException("attribute cannot be written it has a mutability of '" + schemaAttribute.getMutability() + "'", null, "mutability");
        }
    }

    private boolean addSimpleAttribute(ObjectNode resource, SchemaAttribute schemaAttribute, JsonNode value) {
        if (!value.equals((Object)resource.get(schemaAttribute.getName()))) {
            resource.set(schemaAttribute.getName(), value);
            return true;
        }
        return false;
    }

    private boolean addComplexAttribute(ObjectNode resource, SchemaAttribute schemaAttribute, JsonNode value, String extensionUri) {
        if (schemaAttribute.isMultiValued()) {
            return this.addMultiValuedComplexNode(resource, schemaAttribute, value, extensionUri);
        }
        if (value.equals((Object)resource.get(schemaAttribute.getName()))) {
            return false;
        }
        if (PatchOp.ADD.equals((Object)this.patchOp)) {
            Object complexNode = resource.get(schemaAttribute.getName()) == null ? new ScimObjectNode(schemaAttribute) : (ObjectNode)resource.get(schemaAttribute.getName());
            AtomicBoolean changeWasMade = new AtomicBoolean(false);
            value.fields().forEachRemaining(arg_0 -> this.lambda$addComplexAttribute$2(extensionUri, schemaAttribute, (ObjectNode)complexNode, changeWasMade, arg_0));
            if (changeWasMade.get()) {
                resource.set(schemaAttribute.getName(), (JsonNode)complexNode);
            }
            return changeWasMade.get();
        }
        resource.set(schemaAttribute.getName(), value);
        return true;
    }

    private boolean addMultiValuedComplexNode(ObjectNode resource, SchemaAttribute schemaAttribute, JsonNode value, String extensionUri) {
        ArrayNode arrayNode;
        JsonNode multiValuedComplexNode = resource.get(schemaAttribute.getName());
        boolean changeWasMade = true;
        if (multiValuedComplexNode == null) {
            arrayNode = new ScimArrayNode(schemaAttribute);
        } else {
            arrayNode = (ArrayNode)multiValuedComplexNode;
            if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
                if (arrayNode.equals((Object)value)) {
                    changeWasMade = false;
                }
                arrayNode.removeAll();
            }
        }
        Optional<JsonNode> primaryNode = this.getPrimaryFromMultiComplex(arrayNode);
        AtomicBoolean newPrimaryNodeDetected = new AtomicBoolean(false);
        value.forEach(complex -> {
            boolean primaryFound;
            complex.fields().forEachRemaining(stringJsonNodeEntry -> {
                String fullName = (extensionUri == null ? "" : extensionUri + ":") + schemaAttribute.getName() + "." + (String)stringJsonNodeEntry.getKey();
                SchemaAttribute subAttribute = RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, fullName);
                this.verifyImmutableAndReadOnly((JsonNode)complex, subAttribute);
            });
            JsonNode prime = complex.get("primary");
            boolean bl = primaryFound = prime != null && prime.booleanValue();
            if (newPrimaryNodeDetected.get()) {
                throw new BadRequestException("Found 2 primary values in the new dataset of node: " + schemaAttribute.getFullResourceName(), null, "invalidValue");
            }
            newPrimaryNodeDetected.weakCompareAndSet(false, primaryFound);
            arrayNode.add(complex);
        });
        if (newPrimaryNodeDetected.get()) {
            primaryNode.ifPresent(complex -> JsonHelper.removeAttribute((JsonNode)complex, (String)"primary"));
        }
        resource.set(schemaAttribute.getName(), (JsonNode)arrayNode);
        return changeWasMade;
    }

    private Optional<JsonNode> getPrimaryFromMultiComplex(ArrayNode arrayNode) {
        for (JsonNode complex : arrayNode) {
            JsonNode primaryNode = complex.get("primary");
            if (primaryNode == null || !primaryNode.booleanValue()) continue;
            return Optional.of(complex);
        }
        return Optional.empty();
    }

    private boolean addMultivaluedAttribute(ObjectNode resource, SchemaAttribute schemaAttribute, JsonNode value) {
        Object arrayNode = resource.get(schemaAttribute.getName()) == null ? new ScimArrayNode(schemaAttribute) : (ArrayNode)resource.get(schemaAttribute.getName());
        for (JsonNode jsonNode : value) {
            arrayNode.add(jsonNode);
        }
        resource.set(schemaAttribute.getName(), (JsonNode)arrayNode);
        return true;
    }

    private /* synthetic */ void lambda$addComplexAttribute$2(String extensionUri, SchemaAttribute schemaAttribute, ObjectNode complexNode, AtomicBoolean changeWasMade, Map.Entry stringJsonNodeEntry) {
        String key = (String)stringJsonNodeEntry.getKey();
        JsonNode newValue = (JsonNode)stringJsonNodeEntry.getValue();
        String uri = extensionUri == null ? this.resourceType.getSchema() : extensionUri;
        String fullName = uri + ":" + schemaAttribute.getName() + "." + key;
        SchemaAttribute subAttribute = RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, fullName);
        this.verifyImmutableAndReadOnly((JsonNode)complexNode, subAttribute);
        if (!newValue.equals((Object)complexNode.get(key))) {
            complexNode.set(key, newValue);
            changeWasMade.set(true);
        }
    }
}

