/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter;

import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidFilterException;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.antlr.Comparator;
import de.captaingoldfish.scim.sdk.server.filter.antlr.CompareValue;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterAttributeName;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;

public final class AttributeExpressionLeaf
extends FilterNode {
    private final FilterAttributeName attributeName;
    private final Comparator comparator;
    private final CompareValue compareValue;
    private final SchemaAttribute schemaAttribute;

    public AttributeExpressionLeaf(ScimFilterParser.AttributeExpressionContext context, ResourceType resourceType) {
        ScimFilterParser.ValuePathContext attributeValuePath = this.getParentValuePath(context);
        this.comparator = Comparator.valueOf(this.getCompareOperatorValue(context));
        FilterAttributeName attributeName = new FilterAttributeName(attributeValuePath, context.attributePath());
        String parentName = attributeName.getParentAttributeName();
        if (attributeValuePath != null) {
            String subName;
            String string = subName = attributeValuePath.subattribute == null ? null : attributeValuePath.subattribute.getText();
            if (subName != null) {
                String fullSubname = StringUtils.stripToEmpty((String)parentName) + subName;
                SchemaAttribute subAttributeSchema = RequestUtils.getSchemaAttributeByAttributeName(resourceType, fullSubname);
                super.setSubAttributeName(subAttributeSchema == null ? null : subAttributeSchema.getName());
            }
        }
        this.schemaAttribute = RequestUtils.getSchemaAttributeForFilter(resourceType, attributeName);
        this.attributeName = parentName != null && !parentName.equals(this.schemaAttribute.getParent().getName()) ? new FilterAttributeName(this.schemaAttribute.getParent().getScimNodeName(), context.attributePath()) : attributeName;
        this.compareValue = context.compareValue() == null ? null : new CompareValue(context.compareValue(), this.schemaAttribute);
        this.validateFilterComparator();
    }

    public String getParentAttributeName() {
        return this.attributeName.getParentAttributeName();
    }

    private ScimFilterParser.ValuePathContext getParentValuePath(ParserRuleContext context) {
        if (ScimFilterParser.ValuePathContext.class.isAssignableFrom(context.getClass())) {
            return (ScimFilterParser.ValuePathContext)context;
        }
        if (context.getParent() != null) {
            return this.getParentValuePath(context.getParent());
        }
        return null;
    }

    private void validateFilterComparator() {
        if (Type.BOOLEAN.equals((Object)this.schemaAttribute.getType())) {
            switch (this.comparator) {
                case GE: 
                case GT: 
                case LE: 
                case LT: 
                case SW: 
                case EW: 
                case CO: {
                    throw new InvalidFilterException("the comparator '" + (Object)((Object)this.comparator) + "' is not allowed on attribute type '" + this.schemaAttribute.getType() + "'", null);
                }
            }
        }
        if (Type.DATE_TIME.equals((Object)this.schemaAttribute.getType())) {
            switch (this.comparator) {
                case GE: 
                case GT: 
                case LE: 
                case LT: 
                case EQ: 
                case NE: {
                    if (this.compareValue.isDateTime() || this.compareValue.isNull()) break;
                    throw new InvalidFilterException("the comparator '" + (Object)((Object)this.comparator) + "' in combination with the given value '" + this.compareValue.getValue() + "' is not allowed on attribute type '" + this.schemaAttribute.getType() + "'", null);
                }
                case PR: {
                    break;
                }
                default: {
                    if (this.compareValue.isDateTime() || this.compareValue.isString() || this.compareValue.isNull()) break;
                    throw new InvalidFilterException("the comparator '" + (Object)((Object)this.comparator) + "' in combination with the given value '" + this.compareValue.getValue() + "' is not allowed on attribute type '" + this.schemaAttribute.getType() + "'", null);
                }
            }
        }
    }

    private String getCompareOperatorValue(ScimFilterParser.AttributeExpressionContext context) {
        if (context.compareOperator() == null) {
            return ((ParseTree)context.children.get(1)).getText().toUpperCase();
        }
        return context.compareOperator().getText().toUpperCase();
    }

    public String getResourceUri() {
        return this.attributeName.getResourceUri();
    }

    public String getShortName() {
        return this.attributeName.getShortName();
    }

    public String getFullName() {
        return this.attributeName.getFullName();
    }

    public String getAttributeName() {
        return this.attributeName.getAttributeName();
    }

    public String getComplexSubAttributeName() {
        return this.attributeName.getComplexSubAttributeName();
    }

    public String getValue() {
        return this.compareValue == null ? null : this.compareValue.getValue();
    }

    public Optional<Boolean> getBooleanValue() {
        return this.compareValue == null ? Optional.empty() : this.compareValue.getBooleanValue();
    }

    public Optional<BigDecimal> getNumberValue() {
        return this.compareValue == null ? Optional.empty() : this.compareValue.getNumberValue();
    }

    public Optional<String> getStringValue() {
        return this.compareValue == null ? Optional.empty() : this.compareValue.getStringValue();
    }

    public Optional<Instant> getDateTime() {
        return this.compareValue == null ? Optional.empty() : this.compareValue.getDateTime();
    }

    public Type getType() {
        return this.schemaAttribute.getType();
    }

    public Mutability getMutability() {
        return this.schemaAttribute.getMutability();
    }

    public Uniqueness getUniqueness() {
        return this.schemaAttribute.getUniqueness();
    }

    public boolean isMultiValued() {
        return this.schemaAttribute.isMultiValued();
    }

    public boolean isRequired() {
        return this.schemaAttribute.isRequired();
    }

    public boolean isCaseExact() {
        return this.schemaAttribute.isCaseExact();
    }

    public List<String> getCanonicalValues() {
        return this.schemaAttribute.getCanonicalValues();
    }

    public List<ReferenceTypes> getReferenceTypes() {
        return this.schemaAttribute.getReferenceTypes();
    }

    public boolean isNull() {
        return this.compareValue == null || this.compareValue.isNull();
    }

    public String toString() {
        return this.attributeName + " " + (Object)((Object)this.comparator) + (this.compareValue == null ? "" : " " + this.compareValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeExpressionLeaf)) {
            return false;
        }
        AttributeExpressionLeaf other = (AttributeExpressionLeaf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        Comparator this$comparator = this.getComparator();
        Comparator other$comparator = other.getComparator();
        if (this$comparator == null ? other$comparator != null : !((Object)((Object)this$comparator)).equals((Object)other$comparator)) {
            return false;
        }
        CompareValue this$compareValue = this.compareValue;
        CompareValue other$compareValue = other.compareValue;
        if (this$compareValue == null ? other$compareValue != null : !((Object)this$compareValue).equals(other$compareValue)) {
            return false;
        }
        SchemaAttribute this$schemaAttribute = this.getSchemaAttribute();
        SchemaAttribute other$schemaAttribute = other.getSchemaAttribute();
        return !(this$schemaAttribute == null ? other$schemaAttribute != null : !this$schemaAttribute.equals(other$schemaAttribute));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeExpressionLeaf;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        Comparator $comparator = this.getComparator();
        result = result * 59 + ($comparator == null ? 43 : ((Object)((Object)$comparator)).hashCode());
        CompareValue $compareValue = this.compareValue;
        result = result * 59 + ($compareValue == null ? 43 : ((Object)$compareValue).hashCode());
        SchemaAttribute $schemaAttribute = this.getSchemaAttribute();
        result = result * 59 + ($schemaAttribute == null ? 43 : $schemaAttribute.hashCode());
        return result;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public SchemaAttribute getSchemaAttribute() {
        return this.schemaAttribute;
    }
}

