/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.etag;

import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotModifiedException;
import de.captaingoldfish.scim.sdk.common.exceptions.PreconditionFailedException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETagHandler {
    private static final Logger log = LoggerFactory.getLogger(ETagHandler.class);

    public static Optional<ETag> getResourceVersion(ServiceProvider serviceProvider, ResourceNode resourceNode) {
        if (!serviceProvider.getETagConfig().isSupported()) {
            log.trace("not handling eTags for service provider support for eTags is set to false");
            return Optional.empty();
        }
        Optional<ETag> version = resourceNode.getMeta().flatMap(Meta::getVersion);
        if (version.isPresent()) {
            log.trace("version already set to: {}", (Object)((ETag)version.get()).getEntityTag());
            return version;
        }
        return Optional.of(ETagHandler.generateVersionOfResource(resourceNode));
    }

    private static ETag generateVersionOfResource(ResourceNode resourceNode) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return ETag.builder().weak(Boolean.valueOf(true)).tag(Base64.getEncoder().encodeToString(messageDigest.digest(resourceNode.toString().getBytes(StandardCharsets.UTF_8)))).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e, null);
        }
    }

    public static void validateVersion(ServiceProvider serviceProvider, Supplier<ResourceNode> currentState, Map<String, String> httpHeaders) {
        if (!serviceProvider.getETagConfig().isSupported()) {
            log.debug("not handling eTags for service provider support for eTags is set to false");
            return;
        }
        Optional<ETag> ifNoneMatchEtag = ETagHandler.getETagFromHeader(httpHeaders, true);
        Optional<ETag> ifMatchEtag = ETagHandler.getETagFromHeader(httpHeaders, false);
        if (!ifNoneMatchEtag.isPresent() && !ifMatchEtag.isPresent()) {
            return;
        }
        ResourceNode resourceNode = currentState.get();
        Optional version = resourceNode.getMeta().flatMap(Meta::getVersion);
        ETag currentVersion = version.orElseGet(() -> ETagHandler.generateVersionOfResource(resourceNode));
        if (ifNoneMatchEtag.isPresent()) {
            if (ETagHandler.compareEtags(currentVersion, ifNoneMatchEtag.get())) {
                throw new NotModifiedException();
            }
        } else if (!ETagHandler.compareEtags(currentVersion, ifMatchEtag.get())) {
            throw new PreconditionFailedException("eTag status of resource has changed. Current value is: " + currentVersion.getEntityTag());
        }
    }

    private static boolean compareEtags(ETag currentVersion, ETag requestVersion) {
        return requestVersion.equals((Object)currentVersion);
    }

    protected static Optional<ETag> getETagFromHeader(Map<String, String> httpHeaders, boolean ifNot) {
        String ifMatchValue = httpHeaders.keySet().stream().filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"If-Match")).findAny().orElse(null);
        String ifNoneMatchValue = httpHeaders.keySet().stream().filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"If-None-Match")).findAny().orElse(null);
        if (ifMatchValue != null && ifNoneMatchValue != null) {
            throw new BadRequestException("the http header 'If-Match' and 'If-None-Match' are mutually exclusive you should only send one of these headers per request", null, "invalidParameters");
        }
        Function<Optional, Optional> getValue = value -> {
            if (value.isPresent()) {
                if (StringUtils.isBlank((CharSequence)((ETag)value.get()).getTag())) {
                    return Optional.empty();
                }
                return value;
            }
            return Optional.empty();
        };
        if (ifNot && ifNoneMatchValue != null) {
            return getValue.apply(Optional.ofNullable(httpHeaders.get(ifNoneMatchValue)).map(ETag::parseETag));
        }
        if (!ifNot && ifMatchValue != null) {
            return getValue.apply(Optional.ofNullable(httpHeaders.get(ifMatchValue)).map(ETag::parseETag));
        }
        return Optional.empty();
    }
}

