/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.features;

import de.captaingoldfish.scim.sdk.common.exceptions.ForbiddenException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.custom.EndpointControlFeature;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointFeatureHandler {
    private static final Logger log = LoggerFactory.getLogger(EndpointFeatureHandler.class);

    public static void handleEndpointFeatures(ResourceType resourceType, EndpointType endpointType, Authorization authorization) {
        EndpointFeatureHandler.isEndpointEnabled(resourceType, endpointType);
        EndpointFeatureHandler.isClientAuthorized(resourceType, endpointType, authorization);
    }

    private static void isClientAuthorized(ResourceType resourceType, EndpointType endpointType, Authorization authorization) {
        switch (endpointType) {
            case CREATE: {
                EndpointFeatureHandler.isAuthorized(resourceType, endpointType, authorization, resourceType.getFeatures().getAuthorization().getRolesCreate());
                break;
            }
            case UPDATE: {
                EndpointFeatureHandler.isAuthorized(resourceType, endpointType, authorization, resourceType.getFeatures().getAuthorization().getRolesUpdate());
                break;
            }
            case DELETE: {
                EndpointFeatureHandler.isAuthorized(resourceType, endpointType, authorization, resourceType.getFeatures().getAuthorization().getRolesDelete());
                break;
            }
            default: {
                EndpointFeatureHandler.isAuthorized(resourceType, endpointType, authorization, resourceType.getFeatures().getAuthorization().getRolesGet());
            }
        }
    }

    private static void isAuthorized(ResourceType resourceType, EndpointType endpointType, Authorization authorization, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        if (authorization == null) {
            log.debug("the resource endpoint '{}' requires authorization but there was no authorization information passed. required roles: '{}'", (Object)endpointType, roles);
            throw new ForbiddenException("you are not authorized to access the '" + (Object)((Object)endpointType) + "' endpoint on resource type '" + resourceType.getName() + "'");
        }
        if (!authorization.getClientRoles().containsAll(roles)) {
            log.debug("the client '{}' tried to execute an action without proper authorization. Required authorization is '{}' but the client has '{}'", new Object[]{authorization.getClientId(), roles, authorization.getClientRoles()});
            throw new ForbiddenException("you are not authorized to access the '" + (Object)((Object)endpointType) + "' endpoint on resource type '" + resourceType.getName() + "'");
        }
    }

    private static void isEndpointEnabled(ResourceType resourceType, EndpointType endpointType) {
        if (resourceType.isDisabled()) {
            throw new NotImplementedException("the resource type '" + resourceType.getName() + "' is disabled");
        }
        EndpointControlFeature endpointControlFeature = resourceType.getFeatures().getEndpointControlFeature();
        switch (endpointType) {
            case CREATE: {
                if (!endpointControlFeature.isCreateDisabled()) break;
                throw new NotImplementedException("create is not supported for resource type '" + resourceType.getName() + "'");
            }
            case GET: {
                if (!endpointControlFeature.isGetDisabled()) break;
                throw new NotImplementedException("get is not supported for resource type '" + resourceType.getName() + "'");
            }
            case LIST: {
                if (!endpointControlFeature.isListDisabled()) break;
                throw new NotImplementedException("list is not supported for resource type '" + resourceType.getName() + "'");
            }
            case UPDATE: {
                if (!endpointControlFeature.isUpdateDisabled()) break;
                throw new NotImplementedException("update is not supported for resource type '" + resourceType.getName() + "'");
            }
            case DELETE: {
                if (!endpointControlFeature.isDeleteDisabled()) break;
                throw new NotImplementedException("delete is not supported for resource type '" + resourceType.getName() + "'");
            }
        }
    }
}

