/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class ResourceHandler<T extends ResourceNode> {
    private Class<T> type;

    public ResourceHandler() {
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new InternalServerException("ResourceHandler implementations must be generified!", null, null);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        this.type = (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public abstract T createResource(T var1, Authorization var2);

    public abstract T getResource(String var1, Authorization var2);

    public abstract PartialListResponse<T> listResources(long var1, int var3, FilterNode var4, SchemaAttribute var5, SortOrder var6, List<SchemaAttribute> var7, List<SchemaAttribute> var8, Authorization var9);

    public abstract T updateResource(T var1, Authorization var2);

    public abstract void deleteResource(String var1, Authorization var2);

    public Class<T> getType() {
        return this.type;
    }
}

