/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EndpointDefinition {
    private JsonNode resourceType;
    private JsonNode resourceSchema;
    private List<JsonNode> resourceSchemaExtensions;
    private ResourceHandler resourceHandler;

    public EndpointDefinition(JsonNode resourceType, JsonNode resourceSchema, List<JsonNode> resourceSchemaExtensions, ResourceHandler resourceHandler) {
        this.resourceType = resourceType;
        this.resourceSchema = resourceSchema;
        this.resourceSchemaExtensions = resourceSchemaExtensions == null ? new ArrayList() : resourceSchemaExtensions;
        this.resourceHandler = Objects.requireNonNull(resourceHandler, "the resource handler implementation is mandatory");
    }

    public JsonNode getResourceType() {
        return this.resourceType;
    }

    public JsonNode getResourceSchema() {
        return this.resourceSchema;
    }

    public List<JsonNode> getResourceSchemaExtensions() {
        return this.resourceSchemaExtensions;
    }

    public ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public void setResourceType(JsonNode resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceSchema(JsonNode resourceSchema) {
        this.resourceSchema = resourceSchema;
    }

    public void setResourceSchemaExtensions(List<JsonNode> resourceSchemaExtensions) {
        this.resourceSchemaExtensions = resourceSchemaExtensions;
    }

    public void setResourceHandler(ResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointDefinition)) {
            return false;
        }
        EndpointDefinition other = (EndpointDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonNode this$resourceType = this.getResourceType();
        JsonNode other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        JsonNode this$resourceSchema = this.getResourceSchema();
        JsonNode other$resourceSchema = other.getResourceSchema();
        if (this$resourceSchema == null ? other$resourceSchema != null : !this$resourceSchema.equals(other$resourceSchema)) {
            return false;
        }
        List<JsonNode> this$resourceSchemaExtensions = this.getResourceSchemaExtensions();
        List<JsonNode> other$resourceSchemaExtensions = other.getResourceSchemaExtensions();
        if (this$resourceSchemaExtensions == null ? other$resourceSchemaExtensions != null : !((Object)this$resourceSchemaExtensions).equals(other$resourceSchemaExtensions)) {
            return false;
        }
        ResourceHandler this$resourceHandler = this.getResourceHandler();
        ResourceHandler other$resourceHandler = other.getResourceHandler();
        return !(this$resourceHandler == null ? other$resourceHandler != null : !this$resourceHandler.equals(other$resourceHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonNode $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        JsonNode $resourceSchema = this.getResourceSchema();
        result = result * 59 + ($resourceSchema == null ? 43 : $resourceSchema.hashCode());
        List<JsonNode> $resourceSchemaExtensions = this.getResourceSchemaExtensions();
        result = result * 59 + ($resourceSchemaExtensions == null ? 43 : ((Object)$resourceSchemaExtensions).hashCode());
        ResourceHandler $resourceHandler = this.getResourceHandler();
        result = result * 59 + ($resourceHandler == null ? 43 : $resourceHandler.hashCode());
        return result;
    }

    public String toString() {
        return "EndpointDefinition(resourceType=" + this.getResourceType() + ", resourceSchema=" + this.getResourceSchema() + ", resourceSchemaExtensions=" + this.getResourceSchemaExtensions() + ", resourceHandler=" + this.getResourceHandler() + ")";
    }
}

