// Generated by delombok at Wed Sep 28 16:45:31 CEST 2022
package de.captaingoldfish.scim.sdk.server.endpoints.authorize;

import java.util.Collections;
import java.util.Map;
import java.util.Set;


/**
 * author Pascal Knueppel <br>
 * created at: 09.12.2019 - 11:31 <br>
 * <br>
 * a default implementation for authorization that is used if the developer did not give any authorization
 * information's
 */
public final class DefaultAuthorization implements Authorization
{

  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DefaultAuthorization.class);

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClientId()
  {
    return "Anonymous";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<String> getClientRoles()
  {
    return Collections.emptySet();
  }

  /**
   * the default authorization object will always return true to authenticate the user. Be careful when using
   * this!
   */
  @Override
  public boolean authenticate(Map<String, String> httpHeaders, Map<String, String> queryParams)
  {
    log.warn("Used default authentication that will always return true. Please see \'{}\' and \'{}\' to check "
             + "how to utilize the authentication and authorization features or how to disable it.",
             "https://github.com/Captain-P-Goldfish/SCIM-SDK/wiki/Authentication-and-Authorization#authentication",
             "https://github.com/Captain-P-Goldfish/SCIM-SDK/wiki/Authentication-and-Authorization#authorization");
    return true;
  }
}
