/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ComplexAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultivaluedComplexAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(MultivaluedComplexAttributeValidator.class);

    MultivaluedComplexAttributeValidator() {
    }

    public static ArrayNode parseNodeType(SchemaAttribute schemaAttribute, JsonNode attribute, ContextValidator contextValidator) {
        log.trace("Validating multivalued complex attribute '{}'", (Object)schemaAttribute.getScimNodeName());
        if (attribute == null || attribute.isNull()) {
            return null;
        }
        ArrayNode arrayNode = MultivaluedComplexAttributeValidator.toArrayNode(attribute).orElseThrow(() -> {
            String errorMessage = String.format("Attribute '%s' is expected to be an array but is '%s'", schemaAttribute.getFullResourceName(), attribute);
            return new AttributeValidationException(schemaAttribute, errorMessage);
        });
        ScimArrayNode scimArrayNode = new ScimArrayNode(schemaAttribute);
        if (arrayNode.size() > 0) {
            ArrayList<JsonNode> uniqueValueList = new ArrayList<JsonNode>();
            boolean primaryValueFound = false;
            for (JsonNode jsonNode : arrayNode) {
                MultivaluedComplexAttributeValidator.checkIsObject(jsonNode, schemaAttribute, attribute);
                primaryValueFound = MultivaluedComplexAttributeValidator.checkForDuplicatePrimary(primaryValueFound, jsonNode, schemaAttribute, attribute);
                MultivaluedComplexAttributeValidator.checkForUniqueness(uniqueValueList, jsonNode, schemaAttribute, attribute);
                try {
                    JsonNode parsedComplexNode = ComplexAttributeValidator.parseNodeType(schemaAttribute, jsonNode, contextValidator);
                    if (parsedComplexNode == null) continue;
                    scimArrayNode.add(parsedComplexNode);
                }
                catch (AttributeValidationException ex) {
                    String errorMessage = String.format("Found unsupported value in multivalued complex attribute '%s'", arrayNode);
                    throw new AttributeValidationException(schemaAttribute, errorMessage, ex);
                }
            }
        }
        return scimArrayNode.isEmpty() ? null : scimArrayNode;
    }

    private static void checkForUniqueness(List<JsonNode> uniqueValueList, JsonNode jsonNode, SchemaAttribute schemaAttribute, JsonNode multivaluedComplexParent) {
        if (!Uniqueness.NONE.equals((Object)schemaAttribute.getUniqueness())) {
            if (uniqueValueList.contains(jsonNode)) {
                String errorMessage = String.format("Array with uniqueness '%s' contains duplicate values '%s'", schemaAttribute.getUniqueness().getValue(), multivaluedComplexParent);
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
            uniqueValueList.add(jsonNode);
        }
    }

    private static void checkIsObject(JsonNode multivaluedComplexParentElement, SchemaAttribute schemaAttribute, JsonNode multivaluedComplexParent) {
        if (!multivaluedComplexParentElement.isObject()) {
            String errorMessage = String.format("Attribute '%s' is expected to hold only complex attributes but is '%s'", schemaAttribute.getFullResourceName(), multivaluedComplexParent);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static boolean checkForDuplicatePrimary(boolean primaryValueFound, JsonNode jsonNode, SchemaAttribute schemaAttribute, JsonNode multivaluedComplexParent) {
        boolean isPrimary = MultivaluedComplexAttributeValidator.hasPrimaryValue(jsonNode);
        if (isPrimary && primaryValueFound) {
            String errorMessage = String.format("Attribute '%s' has at least two primary values but only one primaryis allowed '%s'", schemaAttribute.getFullResourceName(), multivaluedComplexParent);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
        return isPrimary;
    }

    private static boolean hasPrimaryValue(JsonNode jsonNode) {
        JsonNode primary = jsonNode.get("primary");
        if (primary == null) {
            return false;
        }
        return primary.booleanValue();
    }

    private static Optional<ArrayNode> toArrayNode(JsonNode attribute) {
        if (attribute.isObject()) {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            arrayNode.add(attribute);
            return Optional.of(arrayNode);
        }
        if (attribute.isArray()) {
            return Optional.of((ArrayNode)attribute);
        }
        return Optional.empty();
    }
}

