/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractSchemaValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.MetaAttributeValidator;
import java.util.Optional;

public class MetaSchemaValidator
extends AbstractSchemaValidator {
    private static final MetaSchemaValidator META_SCHEMA_VALIDATOR = new MetaSchemaValidator();

    private MetaSchemaValidator() {
        super(null, ScimObjectNode.class);
    }

    public static MetaSchemaValidator getInstance() {
        return META_SCHEMA_VALIDATOR;
    }

    @Override
    public ScimObjectNode validateDocument(Schema schema, JsonNode resource) {
        ScimObjectNode scimObjectNode = super.validateDocument(schema, resource);
        ScimArrayNode schemasNode = new ScimArrayNode(Schema.SCHEMAS_ATTRIBUTE);
        schemasNode.add((JsonNode)new ScimTextNode(Schema.SCHEMAS_ATTRIBUTE, schema.getNonNullId()));
        scimObjectNode.set("schemas", (JsonNode)schemasNode);
        return scimObjectNode;
    }

    @Override
    protected Optional<JsonNode> validateAttribute(SchemaAttribute schemaAttribute, JsonNode attribute) {
        return MetaAttributeValidator.validateAttribute(schemaAttribute, attribute);
    }
}

