/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ComplexAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(ComplexAttributeValidator.class);

    ComplexAttributeValidator() {
    }

    public static JsonNode parseNodeType(SchemaAttribute schemaAttribute, JsonNode attribute, ContextValidator contextValidator) {
        log.trace("Validating complex attribute '{}'", (Object)schemaAttribute.getScimNodeName());
        if (!attribute.isObject()) {
            String errorMessage = String.format("Attribute '%s' must be of type object but is '%s'", schemaAttribute.getFullResourceName(), attribute);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
        ScimObjectNode scimObjectNode = new ScimObjectNode(schemaAttribute);
        for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
            JsonNode subNode;
            Optional<JsonNode> validatedNode = ValidationSelector.validateNode(subAttribute, subNode = attribute.get(subAttribute.getName()), contextValidator);
            if (!validatedNode.isPresent()) continue;
            scimObjectNode.set(subAttribute.getName(), validatedNode.get());
        }
        if (scimObjectNode.isEmpty()) {
            log.trace("Evaluated complex node '{}' to an empty object.", (Object)schemaAttribute.getFullResourceName());
        }
        return scimObjectNode.isEmpty() ? null : scimObjectNode;
    }
}

