/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.AttributeExtractor;
import de.captaingoldfish.scim.sdk.common.utils.CaseInsensitiveAttributeExtractor;
import de.captaingoldfish.scim.sdk.common.utils.CaseSensitiveAttributeExtractor;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaValidator.class);
    private final ServiceProvider serviceProvider;
    protected final Class resourceNodeType;

    protected abstract Optional<JsonNode> validateAttribute(SchemaAttribute var1, JsonNode var2);

    public ScimObjectNode validateDocument(Schema schema, JsonNode resource) {
        try {
            this.checkDocumentAndMetaSchemaRelationship(schema, resource);
            ScimObjectNode scimObjectNode = JsonHelper.getNewInstance((Class)this.resourceNodeType);
            return this.validateDocument(scimObjectNode, schema, resource);
        }
        catch (AttributeValidationException ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            String errorMessage = Optional.ofNullable(cause).map(Throwable::getMessage).orElse(ex.getMessage());
            throw new DocumentValidationException(errorMessage, (Throwable)ex, null, null);
        }
    }

    protected JsonNode checkDocumentAndMetaSchemaRelationship(Schema resourceSchema, JsonNode document) {
        String resourceSchemaId = resourceSchema.getNonNullId();
        Supplier<String> noSchemasMessage = () -> String.format("Document does not have a '%s'-attribute", "schemas");
        List documentSchemas = (List)JsonHelper.getSimpleAttributeArray((JsonNode)document, (String)"schemas").orElseThrow(() -> new DocumentValidationException((String)noSchemasMessage.get(), Integer.valueOf(400), null));
        log.trace("Resource schema with id {} does apply to document with schemas '{}'", (Object)resourceSchemaId, (Object)documentSchemas);
        ScimArrayNode schemasNode = new ScimArrayNode(null);
        schemasNode.addAll((Collection)documentSchemas.stream().map(s -> new ScimTextNode(null, s)).collect(Collectors.toList()));
        return schemasNode;
    }

    protected ScimObjectNode validateDocument(ScimObjectNode validatedResource, Schema resourceSchema, JsonNode resource) {
        AttributeExtractor attributeExtractor = this.getAttributeExtractor(resource);
        for (SchemaAttribute schemaAttribute : resourceSchema.getAttributes()) {
            log.trace("Validating attribute '{}'", (Object)schemaAttribute.getScimNodeName());
            String attributeName = schemaAttribute.getName();
            JsonNode attribute = attributeExtractor.getAttribute(schemaAttribute).orElse(null);
            Optional<JsonNode> validatedAttributeOptional = this.validateAttribute(schemaAttribute, attribute);
            validatedAttributeOptional.ifPresent(validatedAttribute -> validatedResource.set(attributeName, validatedAttribute));
        }
        return validatedResource;
    }

    public AttributeExtractor getAttributeExtractor(JsonNode resource) {
        boolean caseInsensitiveValidation = Optional.ofNullable(this.serviceProvider).map(ServiceProvider::isCaseInsensitiveValidation).orElse(false);
        if (caseInsensitiveValidation) {
            return new CaseInsensitiveAttributeExtractor(resource);
        }
        return new CaseSensitiveAttributeExtractor(resource);
    }

    public AbstractSchemaValidator(ServiceProvider serviceProvider, Class resourceNodeType) {
        this.serviceProvider = serviceProvider;
        this.resourceNodeType = resourceNodeType;
    }
}

