/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MsAzurePatchReplaceWorkaroundHandler {
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchReplaceWorkaroundHandler.class);
    private final PatchOp patchOp;
    private final List<String> values;

    public List<String> fixValues() {
        if (!PatchOp.REPLACE.equals((Object)this.patchOp)) {
            log.trace("[MS Azure REPLACE workaround] only handling 'REPLACE' requests");
            return this.values;
        }
        if (this.values.isEmpty()) {
            log.trace("[MS Azure REPLACE workaround] workaround not executed for values-list is empty");
            return this.values;
        }
        if (this.values.size() > 1) {
            log.trace("[MS Azure REPLACE workaround] workaround not executed for values-list with more than one value");
            return this.values;
        }
        String value = this.values.get(0);
        if (!JsonHelper.isValidJson((String)value)) {
            log.trace("[MS Azure REPLACE workaround] attribute in 'value' operand is not valid json: {}", (Object)value);
            return this.values;
        }
        JsonNode jsonNode = JsonHelper.readJsonDocument((String)value);
        boolean isNodeAnObject = Optional.ofNullable(jsonNode).map(JsonNode::isObject).orElse(false);
        if (!isNodeAnObject) {
            log.trace("[MS Azure REPLACE workaround] attribute in 'value' operand is not an object: {}", (Object)value);
            return this.values;
        }
        ObjectNode rootObjectNode = (ObjectNode)jsonNode;
        ArrayList<ObjectNode> resourceObjectNodes = new ArrayList<ObjectNode>();
        resourceObjectNodes.add(rootObjectNode);
        Optional schemas = JsonHelper.getSimpleAttributeArray((JsonNode)rootObjectNode, (String)"schemas");
        if (schemas.isPresent()) {
            Iterator it = rootObjectNode.fieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                if (!((List)schemas.get()).contains(fieldName)) continue;
                JsonNode childNode = rootObjectNode.get(fieldName);
                boolean isChildNodeAnObject = Optional.ofNullable(childNode).map(JsonNode::isObject).orElse(false);
                if (!isChildNodeAnObject) {
                    log.trace("[MS Azure REPLACE workaround] extension attribute in 'value' operand is not an object: {}", (Object)value);
                    return this.values;
                }
                resourceObjectNodes.add((ObjectNode)childNode);
            }
        }
        boolean workaroundApplied = false;
        for (ObjectNode resourceObjectNode : resourceObjectNodes) {
            if (!this.fixValuesForResourceObjectNode(resourceObjectNode)) continue;
            workaroundApplied = true;
        }
        if (workaroundApplied) {
            List<String> newValues = Arrays.asList(JsonHelper.toJsonString((JsonNode)rootObjectNode));
            return newValues;
        }
        return this.values;
    }

    private boolean fixValuesForResourceObjectNode(ObjectNode resourceObjectNode) {
        boolean workaroundApplied = false;
        ArrayList fieldNames = new ArrayList();
        resourceObjectNode.fieldNames().forEachRemaining(fieldNames::add);
        for (String originalFieldName : fieldNames) {
            String[] split;
            if (originalFieldName.lastIndexOf(":") > -1 || (split = originalFieldName.split("\\.")).length != 2) continue;
            JsonNode originalFieldValue = resourceObjectNode.get(originalFieldName);
            String fieldName = split[0];
            String childFieldName = split[1];
            JsonNode node = resourceObjectNode.get(fieldName);
            if (node != null && node.isObject()) {
                ((ObjectNode)node).set(childFieldName, originalFieldValue);
            } else {
                resourceObjectNode.putObject(fieldName).set(childFieldName, originalFieldValue);
            }
            resourceObjectNode.remove(originalFieldName);
            workaroundApplied = true;
        }
        return workaroundApplied;
    }

    public MsAzurePatchReplaceWorkaroundHandler(PatchOp patchOp, List<String> values) {
        this.patchOp = patchOp;
        this.values = values;
    }
}

