/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter.antlr;

import de.captaingoldfish.scim.sdk.server.filter.AndExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.AttributeExpressionLeaf;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.NotExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.OrExpressionNode;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterBaseVisitor;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterVisitor
extends ScimFilterBaseVisitor<FilterNode> {
    private static final Logger log = LoggerFactory.getLogger(FilterVisitor.class);
    private ResourceType resourceType;

    public FilterVisitor(ResourceType resourceType) {
        this.resourceType = Objects.requireNonNull(resourceType);
    }

    @Override
    public FilterNode visitNotExpression(ScimFilterParser.NotExpressionContext ctx) {
        ParseTree rightNode = ctx.getChild(2);
        return new NotExpressionNode((FilterNode)this.visit(rightNode));
    }

    @Override
    public FilterNode visitOrExpression(ScimFilterParser.OrExpressionContext ctx) {
        ParseTree leftNode = ctx.getChild(0);
        ParseTree rightNode = ctx.getChild(2);
        return new OrExpressionNode((FilterNode)this.visit(leftNode), (FilterNode)this.visit(rightNode));
    }

    @Override
    public FilterNode visitAndExpression(ScimFilterParser.AndExpressionContext ctx) {
        ParseTree leftNode = ctx.getChild(0);
        ParseTree rightNode = ctx.getChild(2);
        return new AndExpressionNode((FilterNode)this.visit(leftNode), (FilterNode)this.visit(rightNode));
    }

    @Override
    public FilterNode visitParenthesisExpression(ScimFilterParser.ParenthesisExpressionContext ctx) {
        return (FilterNode)this.visit(ctx.getChild(1));
    }

    @Override
    public FilterNode visitAttributeExpression(ScimFilterParser.AttributeExpressionContext ctx) {
        return new AttributeExpressionLeaf(ctx, this.resourceType);
    }

    @Override
    public FilterNode visitValuePath(ScimFilterParser.ValuePathContext ctx) {
        FilterNode childNode = ctx.filter() == null ? null : (FilterNode)this.visit((ParseTree)ctx.filter());
        return new AttributePathRoot(childNode, this.resourceType, ctx);
    }
}

