/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationContext {
    private static final Logger log = LoggerFactory.getLogger(ValidationContext.class);
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, List<String>> fieldErrors = new HashMap<String, List<String>>();
    private final ResourceType resourceType;
    private final Map<String, String> responseHttpHeaders;
    private int httpResponseStatus;

    public ValidationContext(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.httpResponseStatus = 400;
        this.responseHttpHeaders = new HashMap<String, String>();
    }

    public boolean hasErrors() {
        boolean hasError = !this.errors.isEmpty() || !this.fieldErrors.isEmpty();
        return hasError;
    }

    public void logErrors() {
        this.errors.forEach(arg_0 -> ((Logger)log).debug(arg_0));
        this.fieldErrors.forEach((fieldName, errorList) -> errorList.forEach(errorMessage -> log.debug("{}: {}", fieldName, errorMessage)));
    }

    public void addError(String errorMessage) {
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            this.errors.add(errorMessage);
        } else {
            log.trace("Not adding empty messages to error context.");
        }
    }

    public void addError(String fieldName, String errorMessage) {
        boolean attributeNotFound;
        Optional<SchemaAttribute> schemaAttributeList = this.resourceType.getAllSchemas().stream().map(schema -> schema.getSchemaAttribute(fieldName)).filter(Objects::nonNull).findAny();
        boolean bl = attributeNotFound = !schemaAttributeList.isPresent();
        if (attributeNotFound) {
            String error = String.format("Cannot bind field with name '%s' on error constraint because no such field exists for resource '%s'", fieldName, this.resourceType.getMainSchema().getNonNullId());
            throw new InternalServerException(error);
        }
        List fieldErrorList = this.fieldErrors.computeIfAbsent(fieldName, getOrCreateList -> new ArrayList());
        fieldErrorList.add(errorMessage);
    }

    public void addExceptionMessages(AttributeValidationException ex) {
        String fieldName = ex.getSchemaAttribute().getScimNodeName();
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            this.addError(fieldName, cause.getMessage());
        }
        log.debug(ex.getMessage(), (Throwable)ex);
    }

    public void addExceptionMessages(ScimException ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            this.addError(cause.getMessage());
        }
    }

    public void writeToErrorResponse(ErrorResponse errorResponse) {
        Optional<ArrayNode> errorMessagesArray = this.addUnspecificErrorMessages();
        Optional<ObjectNode> fieldErrorsObject = this.addFieldSpecificErrorMessages();
        if (errorMessagesArray.isPresent()) {
            errorResponse.setDetail(errorMessagesArray.get().get(0).textValue());
        } else {
            String firstErrorMessage = this.fieldErrors.get(this.fieldErrors.keySet().iterator().next()).get(0);
            errorResponse.setDetail(firstErrorMessage);
        }
        ObjectNode errorNode = new ObjectNode(JsonNodeFactory.instance);
        errorMessagesArray.ifPresent(array -> errorNode.set("errorMessages", (JsonNode)array));
        fieldErrorsObject.ifPresent(object -> errorNode.set("fieldErrors", (JsonNode)object));
        errorResponse.set("errors", (JsonNode)errorNode);
        errorResponse.setStatus(this.httpResponseStatus);
        this.responseHttpHeaders.forEach((headerKey, headerValue) -> errorResponse.getHttpHeaders().put(headerKey, headerValue));
    }

    private Optional<ArrayNode> addUnspecificErrorMessages() {
        if (this.errors.isEmpty()) {
            return Optional.empty();
        }
        ArrayNode errorMessages = new ArrayNode(JsonNodeFactory.instance);
        this.errors.forEach(arg_0 -> ((ArrayNode)errorMessages).add(arg_0));
        return Optional.of(errorMessages);
    }

    private Optional<ObjectNode> addFieldSpecificErrorMessages() {
        if (this.fieldErrors.isEmpty()) {
            return Optional.empty();
        }
        ObjectNode fieldErrorNode = new ObjectNode(JsonNodeFactory.instance);
        this.fieldErrors.forEach((fieldName, errorMessageList) -> {
            ArrayNode errorMessages = new ArrayNode(JsonNodeFactory.instance);
            errorMessageList.forEach(arg_0 -> ((ArrayNode)errorMessages).add(arg_0));
            fieldErrorNode.set(fieldName, (JsonNode)errorMessages);
        });
        return Optional.of(fieldErrorNode);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, List<String>> getFieldErrors() {
        return this.fieldErrors;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Map<String, String> getResponseHttpHeaders() {
        return this.responseHttpHeaders;
    }

    public int getHttpResponseStatus() {
        return this.httpResponseStatus;
    }

    public void setHttpResponseStatus(int httpResponseStatus) {
        this.httpResponseStatus = httpResponseStatus;
    }
}

