/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.features;

import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.DefaultAuthorization;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.custom.EndpointControlFeature;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointFeatureHandler {
    private static final Logger log = LoggerFactory.getLogger(EndpointFeatureHandler.class);
    private static final DefaultAuthorization DEFAULT_AUTHORIZATION = new DefaultAuthorization();

    public static void handleEndpointFeatures(ResourceType resourceType, EndpointType endpointType, Authorization authorization) {
        EndpointFeatureHandler.isEndpointEnabled(resourceType, endpointType);
        EndpointFeatureHandler.handleAuthorization(resourceType, endpointType, authorization);
    }

    private static void handleAuthorization(ResourceType resourceType, EndpointType endpointType, Authorization authorization) {
        ResourceTypeAuthorization resourceTypeAuthorization = resourceType.getFeatures().getAuthorization();
        if (!resourceTypeAuthorization.isAuthenticated()) {
            return;
        }
        if (authorization != null) {
            authorization.isClientAuthorized(resourceType, endpointType);
        } else {
            log.trace("No authorization information for the current client on resource endpoint '{}' for endpoint-type '{}'. Using default authorization handler", (Object)resourceType.getEndpoint(), (Object)endpointType);
            DEFAULT_AUTHORIZATION.isClientAuthorized(resourceType, endpointType);
        }
    }

    private static void isEndpointEnabled(ResourceType resourceType, EndpointType endpointType) {
        if (resourceType.isDisabled()) {
            throw new NotImplementedException("the resource type '" + resourceType.getName() + "' is disabled");
        }
        EndpointControlFeature endpointControlFeature = resourceType.getFeatures().getEndpointControlFeature();
        switch (endpointType) {
            case CREATE: {
                if (!endpointControlFeature.isCreateDisabled()) break;
                throw new NotImplementedException("create is not supported for resource type '" + resourceType.getName() + "'");
            }
            case GET: {
                if (!endpointControlFeature.isGetDisabled()) break;
                throw new NotImplementedException("get is not supported for resource type '" + resourceType.getName() + "'");
            }
            case LIST: {
                if (!endpointControlFeature.isListDisabled()) break;
                throw new NotImplementedException("list is not supported for resource type '" + resourceType.getName() + "'");
            }
            case UPDATE: {
                if (!endpointControlFeature.isUpdateDisabled()) break;
                throw new NotImplementedException("update is not supported for resource type '" + resourceType.getName() + "'");
            }
            case DELETE: {
                if (!endpointControlFeature.isDeleteDisabled()) break;
                throw new NotImplementedException("delete is not supported for resource type '" + resourceType.getName() + "'");
            }
        }
    }
}

