/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.ConflictException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.request.BulkRequest;
import de.captaingoldfish.scim.sdk.common.request.BulkRequestOperation;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseOperation;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceEndpoint;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaFactory;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestSchemaValidator;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BulkEndpoint.class);
    private final ResourceEndpoint resourceEndpoint;
    private final ServiceProvider serviceProvider;
    private final ResourceTypeFactory resourceTypeFactory;
    private final Consumer<ResourceType> doBeforeExecution;
    private final Map<String, String> resolvedBulkIds = new HashMap<String, String>();
    private final Map<String, Set<String>> circularReferenceDetectorMap = new HashMap<String, Set<String>>();
    private final Map<String, String> originalHttpHeaders;
    private final Map<String, String> originalQueryParams;

    public BulkEndpoint(ResourceEndpoint resourceEndpoint, ServiceProvider serviceProvider, ResourceTypeFactory resourceTypeFactory, Map<String, String> originalHttpHeaders, Map<String, String> originalQueryParams, Consumer<ResourceType> doBeforeExecution) {
        this.resourceEndpoint = resourceEndpoint;
        this.serviceProvider = serviceProvider;
        this.resourceTypeFactory = resourceTypeFactory;
        this.originalHttpHeaders = originalHttpHeaders;
        this.originalQueryParams = originalQueryParams;
        this.doBeforeExecution = doBeforeExecution;
    }

    public BulkResponse bulk(String baseUri, String requestBody, Context context) {
        BulkRequest bulkRequest = this.parseAndValidateBulkRequest(requestBody);
        List operations = bulkRequest.getBulkRequestOperations();
        ArrayList<BulkResponseOperation> responseOperations = new ArrayList<BulkResponseOperation>();
        int failOnErrors = RequestUtils.getEffectiveFailOnErrors(bulkRequest);
        int httpStatus = this.handleBulkOperationList(baseUri, operations, responseOperations, failOnErrors, context);
        return BulkResponse.builder().httpStatus(httpStatus).bulkResponseOperation(responseOperations).build();
    }

    private int handleBulkOperationList(String baseUri, List<BulkRequestOperation> operations, List<BulkResponseOperation> responseOperations, int failOnErrors, Context context) {
        int errorCounter = 0;
        long maxIterations = (long)this.serviceProvider.getBulkConfig().getMaxOperations().intValue() * 2L;
        int iterations = 0;
        while (!operations.isEmpty() && (long)iterations < maxIterations) {
            ++iterations;
            BulkRequestOperation requestOperation = operations.get(0);
            if (errorCounter >= failOnErrors) break;
            try {
                this.validateOperation(requestOperation);
            }
            catch (BadRequestException ex) {
                ++errorCounter;
                BulkResponseOperation.BulkResponseOperationBuilder responseBuilder = BulkResponseOperation.builder();
                responseOperations.add(responseBuilder.status(Integer.valueOf(ex.getStatus())).response((ScimObjectNode)new ErrorResponse((ScimException)ex)).build());
                operations.remove(0);
                continue;
            }
            BulkResponseOperation bulkResponseOperation = this.handleSingleBulkOperation(baseUri, requestOperation, context);
            if (bulkResponseOperation == null) {
                String operationIdentifier = UUID.randomUUID().toString();
                requestOperation.setUniqueIdentifier(operationIdentifier);
                operations.remove(0);
                operations.add(requestOperation);
                continue;
            }
            operations.remove(0);
            boolean isSuccessfulResponseCode = this.isSuccessResponseCode(requestOperation, bulkResponseOperation);
            if (!isSuccessfulResponseCode) {
                ++errorCounter;
            }
            responseOperations.add(bulkResponseOperation);
        }
        int httpStatus = 200;
        if (errorCounter >= failOnErrors) {
            httpStatus = 412;
        } else if ((long)iterations >= maxIterations) {
            httpStatus = 500;
        }
        return httpStatus;
    }

    private boolean isSuccessResponseCode(BulkRequestOperation requestOperation, BulkResponseOperation responseOperation) {
        switch (requestOperation.getMethod()) {
            case POST: {
                return 201 == responseOperation.getStatus();
            }
            case DELETE: {
                return 204 == responseOperation.getStatus();
            }
        }
        return 200 == responseOperation.getStatus();
    }

    private BulkResponseOperation handleSingleBulkOperation(String baseUri, BulkRequestOperation operation, Context context) {
        HttpMethod httpMethod = operation.getMethod();
        Map<String, String> httpHeaders = this.getHttpHeadersForBulk(operation);
        UriInfos operationUriInfo = UriInfos.getRequestUrlInfos(this.getResourceTypeFactory(), baseUri + operation.getPath(), httpMethod, httpHeaders);
        operationUriInfo.getQueryParameters().putAll(this.originalQueryParams);
        String id = Optional.ofNullable(operationUriInfo.getResourceId()).map(resourceId -> "/" + resourceId).orElse("");
        String location = baseUri + operationUriInfo.getResourceEndpoint() + id;
        String bulkId = operation.getBulkId().orElse(null);
        BulkResponseOperation.BulkResponseOperationBuilder responseBuilder = BulkResponseOperation.builder().bulkId(bulkId).method(httpMethod).location(location);
        try {
            if (!this.resolveBulkIds(operation, operationUriInfo.getResourceType()) || !this.resolveBulkIdInResourceId(operation, operationUriInfo)) {
                return null;
            }
        }
        catch (ScimException ex) {
            return responseBuilder.status(Integer.valueOf(ex.getStatus())).response((ScimObjectNode)new ErrorResponse(ex)).build();
        }
        responseBuilder.bulkId((String)operation.getBulkId().orElse(null)).method(operation.getMethod()).location(location);
        ScimResponse scimResponse = this.resourceEndpoint.resolveRequest(httpMethod, operation.getData().orElse(null), operationUriInfo, this.doBeforeExecution, context);
        boolean isErrorResponse = ErrorResponse.class.isAssignableFrom(scimResponse.getClass());
        responseBuilder.status(Integer.valueOf(scimResponse.getHttpStatus()));
        if (isErrorResponse) {
            responseBuilder.response((ScimObjectNode)scimResponse);
        } else {
            this.addResponse(operation, scimResponse, operationUriInfo.getResourceType(), responseBuilder);
        }
        if (isErrorResponse) {
            if (HttpMethod.POST.equals((Object)operation.getMethod())) {
                responseBuilder.location(null);
            }
        } else {
            id = Optional.ofNullable(scimResponse.get("id")).map(jsonNode -> "/" + jsonNode.textValue()).orElse("");
            location = baseUri + operationUriInfo.getResourceEndpoint() + id;
            responseBuilder.location(location);
            boolean isResourceDeleted = HttpMethod.DELETE.equals((Object)operationUriInfo.getHttpMethod());
            if (isResourceDeleted) {
                responseBuilder.resourceId(operationUriInfo.getResourceId());
            } else {
                ETag resourceVersion = Optional.ofNullable(scimResponse.get("meta")).map(JsonNode::toString).map(metaResource -> {
                    Meta meta = (Meta)JsonHelper.readJsonDocument((String)metaResource, Meta.class);
                    return meta.getVersion().orElse(null);
                }).orElse(null);
                responseBuilder.version(resourceVersion);
                String resourceId2 = Optional.ofNullable(scimResponse.get("id")).map(JsonNode::textValue).orElse(null);
                responseBuilder.resourceId(resourceId2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)id) && operation.getBulkId().isPresent()) {
            this.resolvedBulkIds.put((String)operation.getBulkId().get(), id.substring(1));
        }
        return responseBuilder.build();
    }

    private void addResponse(BulkRequestOperation operation, ScimResponse scimResponse, ResourceType resourceType, BulkResponseOperation.BulkResponseOperationBuilder responseBuilder) {
        if (!this.serviceProvider.getBulkConfig().isReturnResourcesEnabled()) {
            return;
        }
        if (resourceType.getFeatures().isBlockReturnResourcesOnBulk()) {
            return;
        }
        boolean returnResourceByDefault = this.serviceProvider.getBulkConfig().isReturnResourcesByDefault();
        boolean doesClientWantResourceBack = operation.isReturnResource().orElse(returnResourceByDefault);
        if (doesClientWantResourceBack) {
            responseBuilder.response((ScimObjectNode)scimResponse);
        }
    }

    private Map<String, String> getHttpHeadersForBulk(BulkRequestOperation operation) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(this.originalHttpHeaders);
        httpHeaders.put("/Bulk", "true");
        operation.getVersion().ifPresent(eTag -> httpHeaders.put("If-Match", eTag.getEntityTag()));
        return httpHeaders;
    }

    private boolean resolveBulkIdInResourceId(BulkRequestOperation operation, UriInfos operationUriInfo) {
        switch (operationUriInfo.getHttpMethod()) {
            case DELETE: 
            case PUT: 
            case PATCH: {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)operationUriInfo.getResourceId(), (CharSequence)"bulkId:")) break;
                String resourceId = operationUriInfo.getResourceId();
                String[] bulkIdParts = resourceId.split(":");
                if (bulkIdParts.length != 2) {
                    throw new BadRequestException("the value '" + resourceId + "' is not a valid bulkId reference", null, "invalidValue");
                }
                String bulkId = bulkIdParts[1];
                String resolvedId = this.resolvedBulkIds.get(bulkId);
                if (StringUtils.isBlank((CharSequence)resolvedId)) {
                    if (StringUtils.isNotBlank((CharSequence)operation.getUniqueIdentifier())) {
                        throw new BadRequestException("the operation could not be resolved because the following bulkId-reference could not be resolved '" + resourceId + "'", null, "invalidValue");
                    }
                    return false;
                }
                operationUriInfo.setResourceId(resolvedId);
                break;
            }
        }
        return true;
    }

    private boolean resolveBulkIds(BulkRequestOperation operation, ResourceType resourceType) {
        List<JsonNode> bulkIdNodes;
        String resourceData = operation.getData().orElse(null);
        ScimObjectNode resource = null;
        String bulkId = operation.getBulkId().orElse(null);
        if (!HttpMethod.PATCH.equals((Object)operation.getMethod())) {
            if (StringUtils.isBlank((CharSequence)resourceData)) {
                return true;
            }
            resource = (ScimObjectNode)JsonHelper.readJsonDocument((String)resourceData, ScimObjectNode.class);
            bulkIdNodes = this.getBulkIdNodes(resource, resourceType);
            this.checkForSelfOrCircularReference(bulkId, bulkIdNodes);
            bulkIdNodes = this.setBulkIds(bulkIdNodes);
        } else {
            PatchOpRequest patchOpRequest = (PatchOpRequest)JsonHelper.readJsonDocument((String)operation.getData().orElse(null), PatchOpRequest.class);
            bulkIdNodes = this.getBulkIdNodesForPatch(patchOpRequest, resourceType, bulkId);
            this.checkForSelfOrCircularReference(bulkId, bulkIdNodes);
            resource = patchOpRequest;
        }
        operation.setData(resource == null ? null : resource.toString());
        if (bulkIdNodes.isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)operation.getUniqueIdentifier())) {
            throw new BadRequestException("the operation could not be resolved because the following bulkId-references could not be resolved '" + bulkIdNodes.stream().map(jsonNode -> jsonNode.get("value").textValue()).collect(Collectors.joining(", ")) + "'", null, "invalidValue");
        }
        return false;
    }

    private List<JsonNode> getBulkIdNodesForPatch(PatchOpRequest patchOpRequest, ResourceType resourceType, String bulkId) {
        List operationList = patchOpRequest.getOperations();
        for (PatchRequestOperation operation : operationList) {
            switch (operation.getOp()) {
                case ADD: 
                case REPLACE: {
                    if (operation.getPath().isPresent()) {
                        return this.getBulkIdsForPatchWithPath(resourceType, operation);
                    }
                    return this.getBulkIdsForPatchAddOnResource(operation, resourceType, bulkId);
                }
            }
        }
        return Collections.emptyList();
    }

    private List<JsonNode> getBulkIdsForPatchWithPath(ResourceType resourceType, PatchRequestOperation operation) {
        boolean containsBulkId = operation.getValues().stream().anyMatch(s -> StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)"bulkId:"));
        if (containsBulkId) {
            AttributePathRoot pathRoot = RequestUtils.parsePatchPath(resourceType, (String)operation.getPath().get());
            String attributeName = pathRoot.getFullName() + (pathRoot.getSubAttributeName() == null ? "" : "." + pathRoot.getSubAttributeName());
            SchemaAttribute attribute = RequestUtils.getSchemaAttributeByAttributeName(resourceType, attributeName);
            if (attribute.getSchema().getBulkIdCandidates().contains(attribute.getParent() == null ? attribute : attribute.getParent())) {
                List<JsonNode> unresolvedAttributes = this.resolvePatchValuesWithPath(attributeName, operation);
                return unresolvedAttributes;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<JsonNode> resolvePatchValuesWithPath(String attributeName, PatchRequestOperation operation) {
        String[] attributeNameParts = attributeName.split("\\.");
        if (attributeNameParts.length == 2) {
            return this.resolvePatchValuesWithPathForSimpleValue(attributeNameParts[1], operation);
        }
        return this.resolvePatchValuesWithPathForComplexValue(operation);
    }

    private List<JsonNode> resolvePatchValuesWithPathForComplexValue(PatchRequestOperation operation) {
        List bulkIdValues = operation.getValues().stream().filter(s -> StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)"bulkId:")).collect(Collectors.toList());
        List newValuesList = operation.getValues().stream().filter(s -> !StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)"bulkId:")).collect(Collectors.toList());
        ArrayList<JsonNode> unresolvedValues = new ArrayList<JsonNode>();
        for (String complexNode : bulkIdValues) {
            ScimObjectNode scimObjectNode = (ScimObjectNode)JsonHelper.readJsonDocument((String)complexNode, ScimObjectNode.class);
            JsonNode valueNode = scimObjectNode.get("value");
            String bulkId = valueNode.textValue().replaceFirst("(?i)^bulkId:", "");
            String resolvedResourceId = this.resolvedBulkIds.get(bulkId);
            if (StringUtils.isBlank((CharSequence)resolvedResourceId)) {
                unresolvedValues.add((JsonNode)scimObjectNode);
                newValuesList.add(complexNode);
                continue;
            }
            scimObjectNode.set("value", (JsonNode)new TextNode(resolvedResourceId));
            newValuesList.add(scimObjectNode.toString());
        }
        operation.setValues(newValuesList);
        return unresolvedValues;
    }

    private List<JsonNode> resolvePatchValuesWithPathForSimpleValue(String attributeNamePart, PatchRequestOperation operation) {
        List bulkIdValues = operation.getValues().stream().filter(s -> StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)"bulkId:")).collect(Collectors.toList());
        List newValuesList = operation.getValues().stream().filter(s -> !StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)"bulkId:")).collect(Collectors.toList());
        ArrayList<JsonNode> unresolvedValues = new ArrayList<JsonNode>();
        for (String bulkIdValue : bulkIdValues) {
            String bulkId = bulkIdValue.replaceFirst("(?i)^bulkId:", "");
            String resolvedResourceId = this.resolvedBulkIds.get(bulkId);
            if (StringUtils.isBlank((CharSequence)resolvedResourceId)) {
                ScimObjectNode scimObjectNode = new ScimObjectNode();
                scimObjectNode.set(attributeNamePart, (JsonNode)new TextNode(bulkIdValue));
                unresolvedValues.add((JsonNode)scimObjectNode);
                newValuesList.add(bulkIdValue);
                continue;
            }
            newValuesList.add(resolvedResourceId);
        }
        operation.setValues(newValuesList);
        return unresolvedValues;
    }

    private List<JsonNode> getBulkIdsForPatchAddOnResource(PatchRequestOperation operation, ResourceType resourceType, String bulkId) {
        if (operation.getValues().size() != 1) {
            return Collections.emptyList();
        }
        ScimObjectNode scimObjectNode = (ScimObjectNode)JsonHelper.readJsonDocument((String)((String)operation.getValues().get(0)), ScimObjectNode.class);
        List<JsonNode> bulkIdNodes = this.getBulkIdNodes(scimObjectNode, resourceType);
        this.checkForSelfOrCircularReference(bulkId, bulkIdNodes);
        bulkIdNodes = this.setBulkIds(bulkIdNodes);
        operation.setValues(Collections.singletonList(scimObjectNode.toString()));
        return bulkIdNodes;
    }

    private void checkForSelfOrCircularReference(String bulkId, List<JsonNode> bulkIdNodes) {
        if (StringUtils.isBlank((CharSequence)bulkId) || bulkIdNodes.isEmpty()) {
            return;
        }
        for (JsonNode bulkIdNode : bulkIdNodes) {
            JsonNode jsonNode = bulkIdNode.get("value");
            String bulkReference = jsonNode.textValue().replaceFirst("(?i)^bulkId:", "");
            if (bulkReference.equals(bulkId)) {
                throw new BadRequestException("the bulkId '" + bulkId + "' is a self-reference. Self-references will not be resolved", null, "invalidValue");
            }
            Set mainBulkIdSet = this.circularReferenceDetectorMap.computeIfAbsent(bulkId, k -> new HashSet());
            mainBulkIdSet.add(bulkReference);
            Set subBulkIdSet = this.circularReferenceDetectorMap.computeIfAbsent(bulkReference, k -> new HashSet());
            if (!subBulkIdSet.contains(bulkId)) continue;
            throw new ConflictException("the bulkIds '" + bulkId + "' and '" + bulkReference + "' do form a circular reference that cannot be resolved.");
        }
    }

    private List<JsonNode> setBulkIds(List<JsonNode> getBulkIdNodes) {
        ArrayList<JsonNode> unresolvedNodes = new ArrayList<JsonNode>();
        for (JsonNode complexBulkIdNode : getBulkIdNodes) {
            String value = complexBulkIdNode.get("value").textValue();
            String[] bulkIdParts = value.split(":");
            if (bulkIdParts.length != 2) {
                throw new BadRequestException("the value '" + value + "' is not a valid bulkId reference", null, "invalidValue");
            }
            String bulkId = bulkIdParts[1];
            String resourceId = this.resolvedBulkIds.get(bulkId);
            if (StringUtils.isNotBlank((CharSequence)resourceId)) {
                JsonHelper.replaceNode((JsonNode)complexBulkIdNode, (String)"value", (JsonNode)new TextNode(resourceId));
                continue;
            }
            unresolvedNodes.add(complexBulkIdNode);
        }
        return unresolvedNodes;
    }

    private List<JsonNode> getBulkIdNodes(ScimObjectNode resource, ResourceType resourceType) {
        List bulkIdCandidates = resourceType.getAllSchemas().stream().flatMap(schema -> schema.getBulkIdCandidates().stream()).collect(Collectors.toList());
        if (bulkIdCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> bulkIdNodes = new ArrayList<JsonNode>();
        for (SchemaAttribute bulkIdCandidate : bulkIdCandidates) {
            bulkIdNodes.addAll(this.getBulkIdNodes(resourceType, resource, bulkIdCandidate));
        }
        return bulkIdNodes;
    }

    private List<JsonNode> getBulkIdNodes(ResourceType resourceType, ScimObjectNode resource, SchemaAttribute bulkIdCandidate) {
        JsonNode bulkCandidateNode = resource.get(bulkIdCandidate.getName());
        if (bulkCandidateNode == null && (bulkCandidateNode = this.getNodeFromExtension(resourceType, resource, bulkIdCandidate)) == null) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> bulkIdNodes = new ArrayList<JsonNode>();
        if (bulkCandidateNode.isArray()) {
            for (JsonNode complexNode : bulkCandidateNode) {
                JsonNode bulkIdNode = complexNode.get("value");
                if (bulkIdNode == null || !StringUtils.startsWithIgnoreCase((CharSequence)bulkIdNode.textValue(), (CharSequence)"bulkId:")) continue;
                bulkIdNodes.add(complexNode);
            }
        } else {
            JsonNode bulkIdNode = bulkCandidateNode.get("value");
            if (bulkIdNode == null) {
                return Collections.emptyList();
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)bulkIdNode.textValue(), (CharSequence)"bulkId:")) {
                bulkIdNodes.add(bulkCandidateNode);
            }
        }
        return bulkIdNodes;
    }

    private JsonNode getNodeFromExtension(ResourceType resourceType, ScimObjectNode resource, SchemaAttribute bulkIdCandidate) {
        ObjectNode extensionNode;
        boolean isExtensionNode;
        String schemaUri = bulkIdCandidate.getSchema().getId().orElse(null);
        boolean bl = isExtensionNode = !resourceType.getSchema().equals(schemaUri);
        if (isExtensionNode && (extensionNode = (ObjectNode)resource.get(schemaUri)) != null) {
            return extensionNode.get(bulkIdCandidate.getName());
        }
        return null;
    }

    private BulkRequest parseAndValidateBulkRequest(String requestBody) {
        BulkConfig bulkConfig = this.getServiceProvider().getBulkConfig();
        if (!bulkConfig.isSupported()) {
            throw new NotImplementedException("bulk is not supported by this service provider");
        }
        try {
            JsonNode jsonNode = JsonHelper.readJsonDocument((String)requestBody);
            SchemaFactory schemaFactory = this.getResourceTypeFactory().getSchemaFactory();
            Schema bulkRequestSchema = schemaFactory.getMetaSchema("urn:ietf:params:scim:api:messages:2.0:BulkRequest");
            ScimObjectNode validatedRequest = new RequestSchemaValidator(this.serviceProvider, ScimObjectNode.class, HttpMethod.POST).validateDocument(bulkRequestSchema, jsonNode);
            BulkRequest bulkRequest = (BulkRequest)JsonHelper.copyResourceToObject((JsonNode)validatedRequest, BulkRequest.class);
            if (bulkConfig.getMaxOperations() < bulkRequest.getBulkRequestOperations().size()) {
                throw new BadRequestException("too many operations maximum number of operations is '" + bulkConfig.getMaxOperations() + "' but got '" + bulkRequest.getBulkRequestOperations().size() + "'", null, "tooMany");
            }
            if (bulkConfig.getMaxPayloadSize() < (long)requestBody.getBytes().length) {
                throw new BadRequestException("request body too large with '" + requestBody.getBytes().length + "'-bytes maximum payload size is '" + bulkConfig.getMaxPayloadSize() + "'", null, "tooLarge");
            }
            return bulkRequest;
        }
        catch (ScimException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
        }
    }

    private void validateOperation(BulkRequestOperation operation) {
        List<HttpMethod> validMethods = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);
        if (!validMethods.contains(operation.getMethod())) {
            throw new BadRequestException("bulk request used invalid http method. Only the following methods are allowed for bulk: " + validMethods, null, "unparseableRequest");
        }
        if (HttpMethod.POST.equals((Object)operation.getMethod()) && (operation.getBulkId().isPresent() && StringUtils.isBlank((CharSequence)((CharSequence)operation.getBulkId().get())) || !operation.getBulkId().isPresent())) {
            throw new BadRequestException("missing 'bulkId' on BULK-POST request", null, "unparseableRequest");
        }
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }
}

