// Generated by delombok at Wed Jul 13 23:21:23 CEST 2022
package de.captaingoldfish.scim.sdk.server.schemas.custom;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 03.11.2019 - 12:34 <br>
 * <br>
 */
public class ResourceTypeFeatures extends ScimObjectNode
{

  public ResourceTypeFeatures(boolean autoFiltering,
                              boolean autoSorting,
                              boolean singletonEndpoint,
                              EndpointControlFeature endpointControlFeature,
                              ResourceTypeAuthorization authorization,
                              ETagFeature eTagFeature,
                              boolean blockReturnResourcesOnBulk)
  {
    super(null);
    setAutoFiltering(autoFiltering);
    setAutoSorting(autoSorting);
    setSingletonEndpoint(singletonEndpoint);
    setEndpointControlFeature(endpointControlFeature);
    setAuthorization(authorization);
    setETagFeature(eTagFeature);
    setBlockReturnResourcesOnBulk(blockReturnResourcesOnBulk);
  }

  /**
   * a complex type configuration for eTags that describes how the automatic API handling should use ETags
   */
  public ETagFeature getETagFeature()
  {
    Optional<ETagFeature> optionalETagFeature = getObjectAttribute(AttributeNames.RFC7643.ETAG, ETagFeature.class);
    if (optionalETagFeature.isPresent())
    {
      return optionalETagFeature.get();
    }
    else
    {
      ETagFeature eTagFeature = ETagFeature.builder().build();
      setETagFeature(eTagFeature);
      return eTagFeature;
    }
  }

  /**
   * a complex type configuration for eTags that describes how the automatic API handling should use ETags
   */
  public void setETagFeature(ETagFeature eTagFeature)
  {
    setAttribute(AttributeNames.RFC7643.ETAG, eTagFeature);
  }

  /**
   * if true it is not possible to access the list-resources endpoint anymore because all get-requests will be
   * delegated to the get-resource endpoint
   */
  public boolean isSingletonEndpoint()
  {
    return getBooleanAttribute(AttributeNames.Custom.SINGLETON_ENDPOINT).orElse(false);
  }

  /**
   * if true it is not possible to access the list-resources endpoint anymore because all get-requests will be
   * delegated to the get-resource endpoint
   */
  public void setSingletonEndpoint(Boolean singletonEndpoint)
  {
    setAttribute(AttributeNames.Custom.SINGLETON_ENDPOINT, singletonEndpoint);
  }

  /**
   * enables application side filtering. The developer will no longer be able to do the filtering manually if
   * this has been enabled because the developer will be cut off of the filtering information
   */
  public boolean isAutoFiltering()
  {
    return getBooleanAttribute(AttributeNames.Custom.AUTO_FILTERING).orElse(false);
  }

  /**
   * enables application side filtering. The developer will no longer be able to do the filtering manually if
   * this has been enabled because the developer will be cut off of the filtering information
   */
  public void setAutoFiltering(Boolean autoFiltering)
  {
    setAttribute(AttributeNames.Custom.AUTO_FILTERING, autoFiltering);
  }

  /**
   * enables application side sorting. The developer will no longer be able to do the sorting manually if this
   * has been enabled because the developer will be cut off of the sorting information
   */
  public boolean isAutoSorting()
  {
    return getBooleanAttribute(AttributeNames.Custom.AUTO_SORTING).orElse(false);
  }

  /**
   * enables application side sorting. The developer will no longer be able to do the sorting manually if this
   * has been enabled because the developer will be cut off of the sorting information
   */
  public void setAutoSorting(Boolean autoSorting)
  {
    setAttribute(AttributeNames.Custom.AUTO_SORTING, autoSorting);
  }

  /**
   * if the current resource type is disabled
   */
  public boolean isResourceTypeDisabled()
  {
    return getBooleanAttribute(AttributeNames.Custom.RESOURCE_TYPE_DISABLED).orElse(false)
           || getEndpointControlFeature().isResourceTypeDisabled();
  }

  /**
   * disables or enables the current resource type
   */
  public void setResourceTypeDisabled(Boolean disabled)
  {
    setAttribute(AttributeNames.Custom.RESOURCE_TYPE_DISABLED, disabled);
  }

  /**
   * @return the current values of the endpoint control feature
   */
  public EndpointControlFeature getEndpointControlFeature()
  {
    Optional<EndpointControlFeature> endpointControl = getObjectAttribute(AttributeNames.Custom.ENDPOINT_CONTROL,
                                                                          EndpointControlFeature.class);
    if (endpointControl.isPresent())
    {
      return endpointControl.get();
    }
    else
    {
      EndpointControlFeature endpointControlFeature = EndpointControlFeature.builder().build();
      setEndpointControlFeature(endpointControlFeature);
      return endpointControlFeature;
    }
  }

  /**
   * replaces the whole endpoint control feature node
   */
  public void setEndpointControlFeature(EndpointControlFeature endpointControlFeature)
  {
    setAttribute(AttributeNames.Custom.ENDPOINT_CONTROL, endpointControlFeature);
  }

  /**
   * a complex attribute that tells us the which roles the client must have to access the given endpoin
   */
  public ResourceTypeAuthorization getAuthorization()
  {
    Optional<ResourceTypeAuthorization> authorization = getObjectAttribute(AttributeNames.Custom.AUTHORIZATION,
                                                                           ResourceTypeAuthorization.class);
    if (authorization.isPresent())
    {
      return authorization.get();
    }
    else
    {
      ResourceTypeAuthorization resourceTypeAuthorization = ResourceTypeAuthorization.builder().build();
      setAuthorization(resourceTypeAuthorization);
      return resourceTypeAuthorization;
    }
  }

  /**
   * a complex attribute that tells us the which roles the client must have to access the given endpoin
   */
  public void setAuthorization(ResourceTypeAuthorization resourceTypeAuthorization)
  {
    setAttribute(AttributeNames.Custom.AUTHORIZATION, resourceTypeAuthorization);
  }

  /**
   * This attribute allows the service provider to not return a resource on bulk-responses even if the client
   * explicitly asked for it. Default is false so that resources will be returned if the client asks for them
   */
  public boolean isBlockReturnResourcesOnBulk()
  {
    return getBooleanAttribute(AttributeNames.Custom.BLOCK_RETURN_RESOURCES_ON_BULK).orElse(false);
  }

  /**
   * This attribute allows the service provider to not return a resource on bulk-responses even if the client
   * explicitly asked for it. Default is false so that resources will be returned if the client asks for them
   */
  public void setBlockReturnResourcesOnBulk(boolean blockReturnResourcesOnBulk)
  {
    setAttribute(AttributeNames.Custom.BLOCK_RETURN_RESOURCES_ON_BULK, blockReturnResourcesOnBulk);
  }


  @java.lang.SuppressWarnings("all")
  public static class ResourceTypeFeaturesBuilder
  {

    @java.lang.SuppressWarnings("all")
    private boolean autoFiltering;

    @java.lang.SuppressWarnings("all")
    private boolean autoSorting;

    @java.lang.SuppressWarnings("all")
    private boolean singletonEndpoint;

    @java.lang.SuppressWarnings("all")
    private EndpointControlFeature endpointControlFeature;

    @java.lang.SuppressWarnings("all")
    private ResourceTypeAuthorization authorization;

    @java.lang.SuppressWarnings("all")
    private ETagFeature eTagFeature;

    @java.lang.SuppressWarnings("all")
    private boolean blockReturnResourcesOnBulk;

    @java.lang.SuppressWarnings("all")
    ResourceTypeFeaturesBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder autoFiltering(final boolean autoFiltering)
    {
      this.autoFiltering = autoFiltering;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder autoSorting(final boolean autoSorting)
    {
      this.autoSorting = autoSorting;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder singletonEndpoint(final boolean singletonEndpoint)
    {
      this.singletonEndpoint = singletonEndpoint;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder endpointControlFeature(final EndpointControlFeature endpointControlFeature)
    {
      this.endpointControlFeature = endpointControlFeature;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder authorization(final ResourceTypeAuthorization authorization)
    {
      this.authorization = authorization;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder eTagFeature(final ETagFeature eTagFeature)
    {
      this.eTagFeature = eTagFeature;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures.ResourceTypeFeaturesBuilder blockReturnResourcesOnBulk(final boolean blockReturnResourcesOnBulk)
    {
      this.blockReturnResourcesOnBulk = blockReturnResourcesOnBulk;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public ResourceTypeFeatures build()
    {
      return new ResourceTypeFeatures(this.autoFiltering, this.autoSorting, this.singletonEndpoint,
                                      this.endpointControlFeature, this.authorization, this.eTagFeature,
                                      this.blockReturnResourcesOnBulk);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "ResourceTypeFeatures.ResourceTypeFeaturesBuilder(autoFiltering=" + this.autoFiltering + ", autoSorting="
             + this.autoSorting + ", singletonEndpoint=" + this.singletonEndpoint + ", endpointControlFeature="
             + this.endpointControlFeature + ", authorization=" + this.authorization + ", eTagFeature="
             + this.eTagFeature + ", blockReturnResourcesOnBulk=" + this.blockReturnResourcesOnBulk + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static ResourceTypeFeatures.ResourceTypeFeaturesBuilder builder()
  {
    return new ResourceTypeFeatures.ResourceTypeFeaturesBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public ResourceTypeFeatures()
  {}
}
